/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.util.Iterator;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;

public class BulkResponse
extends ActionResponse
implements Iterable<BulkItemResponse> {
    private BulkItemResponse[] responses;
    private long tookInMillis;

    BulkResponse() {
    }

    public BulkResponse(BulkItemResponse[] responses, long tookInMillis) {
        this.responses = responses;
        this.tookInMillis = tookInMillis;
    }

    public TimeValue took() {
        return new TimeValue(this.tookInMillis);
    }

    public TimeValue getTook() {
        return this.took();
    }

    public long tookInMillis() {
        return this.tookInMillis;
    }

    public long getTookInMillis() {
        return this.tookInMillis();
    }

    public boolean hasFailures() {
        for (BulkItemResponse response : this.responses) {
            if (!response.failed()) continue;
            return true;
        }
        return false;
    }

    public String buildFailureMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("failure in bulk execution:");
        for (int i = 0; i < this.responses.length; ++i) {
            BulkItemResponse response = this.responses[i];
            if (!response.failed()) continue;
            sb.append("\n[").append(i).append("]: index [").append(response.index()).append("], type [").append(response.type()).append("], id [").append(response.id()).append("], message [").append(response.failureMessage()).append("]");
        }
        return sb.toString();
    }

    public BulkItemResponse[] items() {
        return this.responses;
    }

    @Override
    public Iterator<BulkItemResponse> iterator() {
        return Iterators.forArray(this.responses);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.responses = new BulkItemResponse[in.readVInt()];
        for (int i = 0; i < this.responses.length; ++i) {
            this.responses[i] = BulkItemResponse.readBulkItem(in);
        }
        this.tookInMillis = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.responses.length);
        for (BulkItemResponse response : this.responses) {
            response.writeTo(out);
        }
        out.writeVLong(this.tookInMillis);
    }
}

