/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.stats;

import java.io.IOException;
import org.elasticsearch.action.admin.indices.stats.CommonStats;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationResponse;
import org.elasticsearch.cluster.routing.ImmutableShardRouting;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ShardStats
extends BroadcastShardOperationResponse {
    private ShardRouting shardRouting;
    CommonStats stats;

    ShardStats() {
    }

    ShardStats(ShardRouting shardRouting) {
        super(shardRouting.index(), shardRouting.id());
        this.shardRouting = shardRouting;
        this.stats = new CommonStats();
    }

    public ShardRouting shardRouting() {
        return this.shardRouting;
    }

    public ShardRouting getShardRouting() {
        return this.shardRouting();
    }

    public CommonStats stats() {
        return this.stats;
    }

    public CommonStats getStats() {
        return this.stats();
    }

    public static ShardStats readShardStats(StreamInput in) throws IOException {
        ShardStats stats = new ShardStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.shardRouting = ImmutableShardRouting.readShardRoutingEntry(in);
        this.stats = CommonStats.readCommonStats(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shardRouting.writeTo(out);
        this.stats.writeTo(out);
    }
}

