/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.FuzzyTermEnum;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.SimilarityDelegator;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.PriorityQueue;

public class FuzzyLikeThisQuery
extends Query {
    static Similarity sim = new DefaultSimilarity();
    Query rewrittenQuery = null;
    ArrayList<FieldVals> fieldVals = new ArrayList();
    Analyzer analyzer;
    ScoreTermQueue q;
    int MAX_VARIANTS_PER_TERM = 50;
    boolean ignoreTF = false;
    private int maxNumTerms;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.analyzer == null ? 0 : this.analyzer.hashCode());
        result = 31 * result + (this.fieldVals == null ? 0 : this.fieldVals.hashCode());
        result = 31 * result + (this.ignoreTF ? 1231 : 1237);
        result = 31 * result + this.maxNumTerms;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FuzzyLikeThisQuery other = (FuzzyLikeThisQuery)obj;
        if (this.analyzer == null ? other.analyzer != null : !this.analyzer.equals(other.analyzer)) {
            return false;
        }
        if (this.fieldVals == null ? other.fieldVals != null : !this.fieldVals.equals(other.fieldVals)) {
            return false;
        }
        if (this.ignoreTF != other.ignoreTF) {
            return false;
        }
        return this.maxNumTerms == other.maxNumTerms;
    }

    public FuzzyLikeThisQuery(int maxNumTerms, Analyzer analyzer) {
        this.q = new ScoreTermQueue(maxNumTerms);
        this.analyzer = analyzer;
        this.maxNumTerms = maxNumTerms;
    }

    public void addTerms(String queryString, String fieldName, float minSimilarity, int prefixLength) {
        this.fieldVals.add(new FieldVals(fieldName, minSimilarity, prefixLength, queryString));
    }

    private void addTerms(IndexReader reader, FieldVals f) throws IOException {
        if (f.queryString == null) {
            return;
        }
        TokenStream ts = this.analyzer.reusableTokenStream(f.fieldName, new StringReader(f.queryString));
        CharTermAttribute termAtt = ts.addAttribute(CharTermAttribute.class);
        int corpusNumDocs = reader.numDocs();
        Term internSavingTemplateTerm = new Term(f.fieldName);
        HashSet<String> processedTerms = new HashSet<String>();
        ts.reset();
        while (ts.incrementToken()) {
            String term = termAtt.toString();
            if (processedTerms.contains(term)) continue;
            processedTerms.add(term);
            ScoreTermQueue variantsQ = new ScoreTermQueue(this.MAX_VARIANTS_PER_TERM);
            float minScore = 0.0f;
            Term startTerm = internSavingTemplateTerm.createTerm(term);
            FuzzyTermEnum fe = new FuzzyTermEnum(reader, startTerm, f.minSimilarity, f.prefixLength);
            TermEnum origEnum = reader.terms(startTerm);
            int df = 0;
            if (startTerm.equals(origEnum.term())) {
                df = origEnum.docFreq();
            }
            int numVariants = 0;
            int totalVariantDocFreqs = 0;
            do {
                Term possibleMatch;
                if ((possibleMatch = fe.term()) == null) continue;
                ++numVariants;
                totalVariantDocFreqs += fe.docFreq();
                float score = fe.difference();
                if (variantsQ.size() >= this.MAX_VARIANTS_PER_TERM && !(score > minScore)) continue;
                ScoreTerm st = new ScoreTerm(possibleMatch, score, startTerm);
                variantsQ.insertWithOverflow(st);
                minScore = ((ScoreTerm)variantsQ.top()).score;
            } while (fe.next());
            if (numVariants <= 0) continue;
            int avgDf = totalVariantDocFreqs / numVariants;
            if (df == 0) {
                df = avgDf;
            }
            int size = variantsQ.size();
            for (int i = 0; i < size; ++i) {
                ScoreTerm st = (ScoreTerm)variantsQ.pop();
                st.score = st.score * st.score * sim.idf(df, corpusNumDocs);
                this.q.insertWithOverflow(st);
            }
        }
        ts.end();
        ts.close();
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.rewrittenQuery != null) {
            return this.rewrittenQuery;
        }
        for (FieldVals f : this.fieldVals) {
            this.addTerms(reader, f);
        }
        this.fieldVals.clear();
        BooleanQuery bq = new BooleanQuery();
        HashMap<Term, ArrayList<ScoreTerm>> variantQueries = new HashMap<Term, ArrayList<ScoreTerm>>();
        int size = this.q.size();
        for (int i = 0; i < size; ++i) {
            ScoreTerm st = (ScoreTerm)this.q.pop();
            ArrayList<ScoreTerm> l = (ArrayList<ScoreTerm>)variantQueries.get(st.fuzziedSourceTerm);
            if (l == null) {
                l = new ArrayList<ScoreTerm>();
                variantQueries.put(st.fuzziedSourceTerm, l);
            }
            l.add(st);
        }
        for (ArrayList variants : variantQueries.values()) {
            if (variants.size() == 1) {
                ScoreTerm st = (ScoreTerm)variants.get(0);
                FuzzyTermQuery tq = new FuzzyTermQuery(st.term, this.ignoreTF);
                tq.setBoost(st.score);
                bq.add(tq, BooleanClause.Occur.SHOULD);
                continue;
            }
            BooleanQuery termVariants = new BooleanQuery(true);
            for (ScoreTerm st : variants) {
                FuzzyTermQuery tq = new FuzzyTermQuery(st.term, this.ignoreTF);
                tq.setBoost(st.score);
                termVariants.add(tq, BooleanClause.Occur.SHOULD);
            }
            bq.add(termVariants, BooleanClause.Occur.SHOULD);
        }
        bq.setBoost(this.getBoost());
        this.rewrittenQuery = bq;
        return bq;
    }

    public String toString(String field) {
        return null;
    }

    public boolean isIgnoreTF() {
        return this.ignoreTF;
    }

    public void setIgnoreTF(boolean ignoreTF) {
        this.ignoreTF = ignoreTF;
    }

    private static class FuzzyTermQuery
    extends TermQuery {
        boolean ignoreTF;

        public FuzzyTermQuery(Term t, boolean ignoreTF) {
            super(t);
            this.ignoreTF = ignoreTF;
        }

        public Similarity getSimilarity(Searcher searcher) {
            Similarity result = super.getSimilarity(searcher);
            result = new SimilarityDelegator(result){

                public float tf(float freq) {
                    if (FuzzyTermQuery.this.ignoreTF) {
                        return 1.0f;
                    }
                    return super.tf(freq);
                }

                public float idf(int docFreq, int numDocs) {
                    return 1.0f;
                }
            };
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScoreTermQueue
    extends PriorityQueue<ScoreTerm> {
        public ScoreTermQueue(int size) {
            this.initialize(size);
        }

        @Override
        protected boolean lessThan(ScoreTerm termA, ScoreTerm termB) {
            if (termA.score == termB.score) {
                return termA.term.compareTo(termB.term) > 0;
            }
            return termA.score < termB.score;
        }
    }

    private static class ScoreTerm {
        public Term term;
        public float score;
        Term fuzziedSourceTerm;

        public ScoreTerm(Term term, float score, Term fuzziedSourceTerm) {
            this.term = term;
            this.score = score;
            this.fuzziedSourceTerm = fuzziedSourceTerm;
        }
    }

    class FieldVals {
        String queryString;
        String fieldName;
        float minSimilarity;
        int prefixLength;

        public FieldVals(String name, float similarity, int length, String queryString) {
            this.fieldName = name;
            this.minSimilarity = similarity;
            this.prefixLength = length;
            this.queryString = queryString;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
            result = 31 * result + Float.floatToIntBits(this.minSimilarity);
            result = 31 * result + this.prefixLength;
            result = 31 * result + (this.queryString == null ? 0 : this.queryString.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FieldVals other = (FieldVals)obj;
            if (this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName)) {
                return false;
            }
            if (Float.floatToIntBits(this.minSimilarity) != Float.floatToIntBits(other.minSimilarity)) {
                return false;
            }
            if (this.prefixLength != other.prefixLength) {
                return false;
            }
            return !(this.queryString == null ? other.queryString != null : !this.queryString.equals(other.queryString));
        }
    }
}

