/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.SearchContext;

public interface FetchSubPhase {
    public Map<String, ? extends SearchParseElement> parseElements();

    public boolean hitExecutionNeeded(SearchContext var1);

    public void hitExecute(SearchContext var1, HitContext var2) throws ElasticSearchException;

    public boolean hitsExecutionNeeded(SearchContext var1);

    public void hitsExecute(SearchContext var1, InternalSearchHit[] var2) throws ElasticSearchException;

    public static class HitContext {
        private InternalSearchHit hit;
        private IndexReader topLevelReader;
        private int topLevelDocId;
        private IndexReader reader;
        private int docId;
        private Document doc;
        private Map<String, Object> cache;

        public void reset(InternalSearchHit hit, IndexReader reader, int docId, IndexReader topLevelReader, int topLevelDocId, Document doc) {
            this.hit = hit;
            this.reader = reader;
            this.docId = docId;
            this.topLevelReader = topLevelReader;
            this.topLevelDocId = topLevelDocId;
            this.doc = doc;
        }

        public InternalSearchHit hit() {
            return this.hit;
        }

        public IndexReader reader() {
            return this.reader;
        }

        public int docId() {
            return this.docId;
        }

        public IndexReader topLevelReader() {
            return this.topLevelReader;
        }

        public int topLevelDocId() {
            return this.topLevelDocId;
        }

        public Document doc() {
            return this.doc;
        }

        public Map<String, Object> cache() {
            if (this.cache == null) {
                this.cache = Maps.newHashMap();
            }
            return this.cache;
        }
    }
}

