/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.histogram.bounded;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.NumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.histogram.HistogramFacet;
import org.elasticsearch.search.facet.histogram.bounded.InternalBoundedCountHistogramFacet;
import org.elasticsearch.search.internal.SearchContext;

public class BoundedCountHistogramFacetCollector
extends AbstractFacetCollector {
    private final String indexFieldName;
    private final HistogramFacet.ComparatorType comparatorType;
    private final FieldDataCache fieldDataCache;
    private final FieldDataType fieldDataType;
    private NumericFieldData fieldData;
    private final HistogramProc histoProc;

    public BoundedCountHistogramFacetCollector(String facetName, String fieldName, long interval, long from, long to, HistogramFacet.ComparatorType comparatorType, SearchContext context) {
        super(facetName);
        this.comparatorType = comparatorType;
        this.fieldDataCache = context.fieldDataCache();
        MapperService.SmartNameFieldMappers smartMappers = context.smartFieldMappers(fieldName);
        if (smartMappers == null || !smartMappers.hasMapper()) {
            throw new FacetPhaseExecutionException(facetName, "No mapping found for field [" + fieldName + "]");
        }
        if (smartMappers.explicitTypeInNameWithDocMapper()) {
            this.setFilter(context.filterCache().cache(smartMappers.docMapper().typeFilter()));
        }
        FieldMapper mapper = smartMappers.mapper();
        this.indexFieldName = mapper.names().indexName();
        this.fieldDataType = mapper.fieldDataType();
        long normalizedFrom = (long)((double)from / (double)interval) * interval;
        long normalizedTo = (long)((double)to / (double)interval) * interval;
        if (to % interval != 0L) {
            normalizedTo += interval;
        }
        long offset = -normalizedFrom;
        int size = (int)((normalizedTo - normalizedFrom) / interval);
        this.histoProc = new HistogramProc(from, to, interval, offset, size);
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        this.fieldData.forEachValueInDoc(doc, this.histoProc);
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        this.fieldData = (NumericFieldData)this.fieldDataCache.cache(this.fieldDataType, reader, this.indexFieldName);
    }

    @Override
    public Facet facet() {
        return new InternalBoundedCountHistogramFacet(this.facetName, this.comparatorType, this.histoProc.interval, -this.histoProc.offset, this.histoProc.size, this.histoProc.counts, true);
    }

    public static class HistogramProc
    implements NumericFieldData.LongValueInDocProc {
        final long from;
        final long to;
        final long interval;
        final long offset;
        final int size;
        final int[] counts;

        public HistogramProc(long from, long to, long interval, long offset, int size) {
            this.from = from;
            this.to = to;
            this.interval = interval;
            this.offset = offset;
            this.size = size;
            this.counts = CacheRecycler.popIntArray(size);
        }

        @Override
        public void onValue(int docId, long value) {
            if (value <= this.from || value > this.to) {
                return;
            }
            int n = (int)((value + this.offset) / this.interval);
            this.counts[n] = this.counts[n] + 1;
        }
    }
}

