/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.histogram;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilderException;
import org.elasticsearch.search.facet.AbstractFacetBuilder;
import org.elasticsearch.search.facet.histogram.HistogramFacet;

public class HistogramFacetBuilder
extends AbstractFacetBuilder {
    private String keyFieldName;
    private String valueFieldName;
    private long interval = -1L;
    private HistogramFacet.ComparatorType comparatorType;
    private Object from;
    private Object to;

    public HistogramFacetBuilder(String name) {
        super(name);
    }

    public HistogramFacetBuilder field(String field) {
        this.keyFieldName = field;
        return this;
    }

    public HistogramFacetBuilder keyField(String keyField) {
        this.keyFieldName = keyField;
        return this;
    }

    public HistogramFacetBuilder valueField(String valueField) {
        this.valueFieldName = valueField;
        return this;
    }

    public HistogramFacetBuilder interval(long interval) {
        this.interval = interval;
        return this;
    }

    public HistogramFacetBuilder interval(long interval, TimeUnit unit) {
        return this.interval(unit.toMillis(interval));
    }

    public HistogramFacetBuilder bounds(Object from, Object to) {
        this.from = from;
        this.to = to;
        return this;
    }

    public HistogramFacetBuilder comparator(HistogramFacet.ComparatorType comparatorType) {
        this.comparatorType = comparatorType;
        return this;
    }

    @Override
    public HistogramFacetBuilder global(boolean global) {
        super.global(global);
        return this;
    }

    @Override
    public HistogramFacetBuilder scope(String scope) {
        super.scope(scope);
        return this;
    }

    @Override
    public HistogramFacetBuilder facetFilter(FilterBuilder filter) {
        this.facetFilter = filter;
        return this;
    }

    @Override
    public HistogramFacetBuilder nested(String nested) {
        this.nested = nested;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.keyFieldName == null) {
            throw new SearchSourceBuilderException("field must be set on histogram facet for facet [" + this.name + "]");
        }
        if (this.interval < 0L) {
            throw new SearchSourceBuilderException("interval must be set on histogram facet for facet [" + this.name + "]");
        }
        builder.startObject(this.name);
        builder.startObject("histogram");
        if (this.valueFieldName != null) {
            builder.field("key_field", this.keyFieldName);
            builder.field("value_field", this.valueFieldName);
        } else {
            builder.field("field", this.keyFieldName);
        }
        builder.field("interval", this.interval);
        if (this.from != null && this.to != null) {
            builder.field("from", this.from);
            builder.field("to", this.to);
        }
        if (this.comparatorType != null) {
            builder.field("comparator", this.comparatorType.description());
        }
        builder.endObject();
        this.addFilterFacetAndGlobal(builder, params);
        builder.endObject();
        return builder;
    }
}

