/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet;

import java.io.IOException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.search.facet.Facet;

public interface InternalFacet
extends Facet,
Streamable,
ToXContent {
    public String streamType();

    public static class Streams {
        private static ImmutableMap<String, Stream> streams = ImmutableMap.of();

        public static synchronized void registerStream(Stream stream, String ... types) {
            MapBuilder<String, Stream> uStreams = MapBuilder.newMapBuilder(streams);
            for (String type : types) {
                uStreams.put(type, stream);
            }
            streams = uStreams.immutableMap();
        }

        public static Stream stream(String type) {
            return streams.get(type);
        }
    }

    public static interface Stream {
        public Facet readFacet(String var1, StreamInput var2) throws IOException;
    }
}

