/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.mapping.delete;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.mapping.delete.DeleteMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.delete.DeleteMappingResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestDeleteMappingAction
extends BaseRestHandler {
    @Inject
    public RestDeleteMappingAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.DELETE, "/{index}/{type}/_mapping", this);
        controller.registerHandler(RestRequest.Method.DELETE, "/{index}/{type}", this);
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        DeleteMappingRequest deleteMappingRequest = Requests.deleteMappingRequest(RestActions.splitIndices(request.param("index")));
        deleteMappingRequest.listenerThreaded(false);
        deleteMappingRequest.type(request.param("type"));
        this.client.admin().indices().deleteMapping(deleteMappingRequest, new ActionListener<DeleteMappingResponse>(){

            @Override
            public void onResponse(DeleteMappingResponse response) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject().field("ok", true);
                    builder.endObject();
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (IOException e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestDeleteMappingAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

