/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor;

import java.util.Map;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Scopes;
import org.elasticsearch.common.inject.assistedinject.FactoryProvider;
import org.elasticsearch.common.inject.multibindings.MapBinder;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.monitor.dump.DumpContributorFactory;
import org.elasticsearch.monitor.dump.DumpMonitorService;
import org.elasticsearch.monitor.dump.cluster.ClusterDumpContributor;
import org.elasticsearch.monitor.dump.heap.HeapDumpContributor;
import org.elasticsearch.monitor.dump.summary.SummaryDumpContributor;
import org.elasticsearch.monitor.dump.thread.ThreadDumpContributor;
import org.elasticsearch.monitor.fs.FsProbe;
import org.elasticsearch.monitor.fs.FsService;
import org.elasticsearch.monitor.fs.JmxFsProbe;
import org.elasticsearch.monitor.fs.SigarFsProbe;
import org.elasticsearch.monitor.jvm.JvmMonitorService;
import org.elasticsearch.monitor.jvm.JvmService;
import org.elasticsearch.monitor.network.JmxNetworkProbe;
import org.elasticsearch.monitor.network.NetworkProbe;
import org.elasticsearch.monitor.network.NetworkService;
import org.elasticsearch.monitor.network.SigarNetworkProbe;
import org.elasticsearch.monitor.os.JmxOsProbe;
import org.elasticsearch.monitor.os.OsProbe;
import org.elasticsearch.monitor.os.OsService;
import org.elasticsearch.monitor.os.SigarOsProbe;
import org.elasticsearch.monitor.process.JmxProcessProbe;
import org.elasticsearch.monitor.process.ProcessProbe;
import org.elasticsearch.monitor.process.ProcessService;
import org.elasticsearch.monitor.process.SigarProcessProbe;
import org.elasticsearch.monitor.sigar.SigarService;

public class MonitorModule
extends AbstractModule {
    private final Settings settings;

    public MonitorModule(Settings settings) {
        this.settings = settings;
    }

    @Override
    protected void configure() {
        boolean sigarLoaded = false;
        try {
            this.settings.getClassLoader().loadClass("org.hyperic.sigar.Sigar");
            SigarService sigarService = new SigarService(this.settings);
            if (sigarService.sigarAvailable()) {
                this.bind(SigarService.class).toInstance(sigarService);
                this.bind(ProcessProbe.class).to(SigarProcessProbe.class).asEagerSingleton();
                this.bind(OsProbe.class).to(SigarOsProbe.class).asEagerSingleton();
                this.bind(NetworkProbe.class).to(SigarNetworkProbe.class).asEagerSingleton();
                this.bind(FsProbe.class).to(SigarFsProbe.class).asEagerSingleton();
                sigarLoaded = true;
            }
        }
        catch (Throwable e) {
            Loggers.getLogger(SigarService.class).trace("failed to load sigar", e, new Object[0]);
        }
        if (!sigarLoaded) {
            this.bind(ProcessProbe.class).to(JmxProcessProbe.class).asEagerSingleton();
            this.bind(OsProbe.class).to(JmxOsProbe.class).asEagerSingleton();
            this.bind(NetworkProbe.class).to(JmxNetworkProbe.class).asEagerSingleton();
            this.bind(FsProbe.class).to(JmxFsProbe.class).asEagerSingleton();
        }
        this.bind(ProcessService.class).asEagerSingleton();
        this.bind(OsService.class).asEagerSingleton();
        this.bind(NetworkService.class).asEagerSingleton();
        this.bind(JvmService.class).asEagerSingleton();
        this.bind(FsService.class).asEagerSingleton();
        this.bind(JvmMonitorService.class).asEagerSingleton();
        MapBinder<String, DumpContributorFactory> tokenFilterBinder = MapBinder.newMapBinder(this.binder(), String.class, DumpContributorFactory.class);
        Map<String, Settings> dumpContSettings = this.settings.getGroups("monitor.dump");
        for (Map.Entry<String, Settings> entry : dumpContSettings.entrySet()) {
            String dumpContributorName = entry.getKey();
            Settings dumpContributorSettings = entry.getValue();
            Class type = dumpContributorSettings.getAsClass("type", null, "org.elasticsearch.monitor.dump." + dumpContributorName + ".", "DumpContributor");
            if (type == null) {
                throw new IllegalArgumentException("Dump Contributor [" + dumpContributorName + "] must have a type associated with it");
            }
            tokenFilterBinder.addBinding(dumpContributorName).toProvider(FactoryProvider.newFactory(DumpContributorFactory.class, type)).in(Scopes.SINGLETON);
        }
        if (!dumpContSettings.containsKey("summary")) {
            tokenFilterBinder.addBinding("summary").toProvider(FactoryProvider.newFactory(DumpContributorFactory.class, SummaryDumpContributor.class)).in(Scopes.SINGLETON);
        }
        if (!dumpContSettings.containsKey("thread")) {
            tokenFilterBinder.addBinding("thread").toProvider(FactoryProvider.newFactory(DumpContributorFactory.class, ThreadDumpContributor.class)).in(Scopes.SINGLETON);
        }
        if (!dumpContSettings.containsKey("heap")) {
            tokenFilterBinder.addBinding("heap").toProvider(FactoryProvider.newFactory(DumpContributorFactory.class, HeapDumpContributor.class)).in(Scopes.SINGLETON);
        }
        if (!dumpContSettings.containsKey("cluster")) {
            tokenFilterBinder.addBinding("cluster").toProvider(FactoryProvider.newFactory(DumpContributorFactory.class, ClusterDumpContributor.class)).in(Scopes.SINGLETON);
        }
        this.bind(DumpMonitorService.class).asEagerSingleton();
    }

    public static final class MonitorSettings {
        public static final String MEMORY_MANAGER_TYPE = "monitor.memory.type";
    }
}

