/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.warmer;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.warmer.IndicesWarmer;
import org.elasticsearch.threadpool.ThreadPool;

public class InternalIndicesWarmer
extends AbstractComponent
implements IndicesWarmer {
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final CopyOnWriteArrayList<IndicesWarmer.Listener> listeners = new CopyOnWriteArrayList();

    @Inject
    public InternalIndicesWarmer(Settings settings, ThreadPool threadPool, ClusterService clusterService, IndicesService indicesService) {
        super(settings);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
    }

    @Override
    public void addListener(IndicesWarmer.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IndicesWarmer.Listener listener) {
        this.listeners.remove(listener);
    }

    public void warm(final IndicesWarmer.WarmerContext context) {
        final IndexMetaData indexMetaData = this.clusterService.state().metaData().index(context.shardId().index().name());
        if (indexMetaData == null) {
            return;
        }
        if (!indexMetaData.settings().getAsBoolean("index.warmer.enabled", this.settings.getAsBoolean("index.warmer.enabled", true)).booleanValue()) {
            return;
        }
        IndexService indexService = this.indicesService.indexService(context.shardId().index().name());
        if (indexService == null) {
            return;
        }
        final IndexShard indexShard = indexService.shard(context.shardId().id());
        if (indexShard == null) {
            return;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[{}][{}] warming [{}], new [{}]", context.shardId().index().name(), context.shardId().id(), context.fullSearcher().reader(), context.newSearcher().reader());
        }
        indexShard.warmerService().onPreWarm();
        long time = System.nanoTime();
        for (final IndicesWarmer.Listener listener : this.listeners) {
            final CountDownLatch latch = new CountDownLatch(1);
            this.threadPool.executor(listener.executor()).execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        listener.warm(indexShard, indexMetaData, context);
                    }
                    catch (Throwable e) {
                        indexShard.warmerService().logger().warn("failed to warm [{}]", e, listener);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                return;
            }
        }
        long took = System.nanoTime() - time;
        indexShard.warmerService().onPostWarm(took);
        if (indexShard.warmerService().logger().isTraceEnabled()) {
            indexShard.warmerService().logger().trace("warming took [{}]", new TimeValue(took, TimeUnit.NANOSECONDS));
        }
    }
}

