/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.warmer;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class WarmerStats
implements Streamable,
ToXContent {
    private long current;
    private long total;
    private long totalTimeInMillis;

    public WarmerStats() {
    }

    public WarmerStats(long current, long total, long totalTimeInMillis) {
        this.current = current;
        this.total = total;
        this.totalTimeInMillis = totalTimeInMillis;
    }

    public void add(long current, long total, long totalTimeInMillis) {
        this.current += current;
        this.total += total;
        this.totalTimeInMillis += totalTimeInMillis;
    }

    public void add(WarmerStats warmerStats) {
        if (warmerStats == null) {
            return;
        }
        this.current += warmerStats.current;
        this.total += warmerStats.total;
        this.totalTimeInMillis += warmerStats.totalTimeInMillis;
    }

    public long current() {
        return this.current;
    }

    public long total() {
        return this.total;
    }

    public long totalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    public TimeValue totalTime() {
        return new TimeValue(this.totalTimeInMillis);
    }

    public static WarmerStats readWarmerStats(StreamInput in) throws IOException {
        WarmerStats refreshStats = new WarmerStats();
        refreshStats.readFrom(in);
        return refreshStats;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.WARMER);
        builder.field(Fields.CURRENT, this.current);
        builder.field(Fields.TOTAL, this.total);
        builder.field(Fields.TOTAL_TIME, this.totalTime().toString());
        builder.field(Fields.TOTAL_TIME_IN_MILLIS, this.totalTimeInMillis);
        builder.endObject();
        return builder;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.current = in.readVLong();
        this.total = in.readVLong();
        this.totalTimeInMillis = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.current);
        out.writeVLong(this.total);
        out.writeVLong(this.totalTimeInMillis);
    }

    static final class Fields {
        static final XContentBuilderString WARMER = new XContentBuilderString("warmer");
        static final XContentBuilderString CURRENT = new XContentBuilderString("current");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString TOTAL_TIME = new XContentBuilderString("total_time");
        static final XContentBuilderString TOTAL_TIME_IN_MILLIS = new XContentBuilderString("total_time_in_millis");

        Fields() {
        }
    }
}

