/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogException;
import org.elasticsearch.index.translog.fs.FsChannelSnapshot;
import org.elasticsearch.index.translog.fs.FsTranslogFile;
import org.elasticsearch.index.translog.fs.RafReference;

public class SimpleFsTranslogFile
implements FsTranslogFile {
    private final long id;
    private final ShardId shardId;
    private final RafReference raf;
    private final AtomicInteger operationCounter = new AtomicInteger();
    private final AtomicLong lastPosition = new AtomicLong(0L);
    private final AtomicLong lastWrittenPosition = new AtomicLong(0L);
    private volatile long lastSyncPosition = 0L;

    public SimpleFsTranslogFile(ShardId shardId, long id, RafReference raf) throws IOException {
        this.shardId = shardId;
        this.id = id;
        this.raf = raf;
        raf.raf().setLength(0L);
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public int estimatedNumberOfOperations() {
        return this.operationCounter.get();
    }

    @Override
    public long translogSizeInBytes() {
        return this.lastWrittenPosition.get();
    }

    @Override
    public Translog.Location add(byte[] data, int from, int size) throws IOException {
        long position = this.lastPosition.getAndAdd(size);
        this.raf.channel().write(ByteBuffer.wrap(data, from, size), position);
        this.lastWrittenPosition.getAndAdd(size);
        this.operationCounter.incrementAndGet();
        return new Translog.Location(this.id, position, size);
    }

    @Override
    public byte[] read(Translog.Location location) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(location.size);
        this.raf.channel().read(buffer, location.translogLocation);
        return buffer.array();
    }

    @Override
    public void close(boolean delete) {
        this.sync();
        this.raf.decreaseRefCount(delete);
    }

    @Override
    public FsChannelSnapshot snapshot() throws TranslogException {
        try {
            if (!this.raf.increaseRefCount()) {
                return null;
            }
            return new FsChannelSnapshot(this.id, this.raf, this.lastWrittenPosition.get(), this.operationCounter.get());
        }
        catch (Exception e) {
            throw new TranslogException(this.shardId, "Failed to snapshot", (Throwable)e);
        }
    }

    @Override
    public boolean syncNeeded() {
        return this.lastWrittenPosition.get() != this.lastSyncPosition;
    }

    @Override
    public void sync() {
        try {
            long last = this.lastWrittenPosition.get();
            if (last == this.lastSyncPosition) {
                return;
            }
            this.lastSyncPosition = last;
            this.raf.channel().force(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void reuse(FsTranslogFile other) {
    }
}

