/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogException;
import org.elasticsearch.index.translog.fs.FsChannelSnapshot;
import org.elasticsearch.index.translog.fs.FsTranslogFile;
import org.elasticsearch.index.translog.fs.RafReference;

public class BufferingFsTranslogFile
implements FsTranslogFile {
    private final long id;
    private final ShardId shardId;
    private final RafReference raf;
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();
    private volatile int operationCounter;
    private long lastPosition;
    private volatile long lastWrittenPosition;
    private volatile long lastSyncPosition = 0L;
    private byte[] buffer;
    private int bufferCount;

    public BufferingFsTranslogFile(ShardId shardId, long id, RafReference raf, int bufferSize) throws IOException {
        this.shardId = shardId;
        this.id = id;
        this.raf = raf;
        this.buffer = new byte[bufferSize];
        raf.raf().setLength(0L);
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public int estimatedNumberOfOperations() {
        return this.operationCounter;
    }

    @Override
    public long translogSizeInBytes() {
        return this.lastWrittenPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Translog.Location add(byte[] data, int from, int size) throws IOException {
        this.rwl.writeLock().lock();
        try {
            ++this.operationCounter;
            long position = this.lastPosition;
            if (size >= this.buffer.length) {
                this.flushBuffer();
                this.raf.channel().write(ByteBuffer.wrap(data, from, size));
                this.lastWrittenPosition += (long)size;
                this.lastPosition += (long)size;
                Translog.Location location = new Translog.Location(this.id, position, size);
                return location;
            }
            if (size > this.buffer.length - this.bufferCount) {
                this.flushBuffer();
            }
            System.arraycopy(data, from, this.buffer, this.bufferCount, size);
            this.bufferCount += size;
            this.lastPosition += (long)size;
            Translog.Location location = new Translog.Location(this.id, position, size);
            return location;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    private void flushBuffer() throws IOException {
        if (this.bufferCount > 0) {
            this.raf.channel().write(ByteBuffer.wrap(this.buffer, 0, this.bufferCount));
            this.lastWrittenPosition += (long)this.bufferCount;
            this.bufferCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] read(Translog.Location location) throws IOException {
        this.rwl.readLock().lock();
        try {
            if (location.translogLocation >= this.lastWrittenPosition) {
                byte[] data = new byte[location.size];
                System.arraycopy(this.buffer, (int)(location.translogLocation - this.lastWrittenPosition), data, 0, location.size);
                byte[] byArray = data;
                return byArray;
            }
        }
        finally {
            this.rwl.readLock().unlock();
        }
        ByteBuffer buffer = ByteBuffer.allocate(location.size);
        this.raf.channel().read(buffer, location.translogLocation);
        return buffer.array();
    }

    @Override
    public FsChannelSnapshot snapshot() throws TranslogException {
        this.rwl.writeLock().lock();
        try {
            this.flushBuffer();
            if (!this.raf.increaseRefCount()) {
                FsChannelSnapshot fsChannelSnapshot = null;
                return fsChannelSnapshot;
            }
            FsChannelSnapshot fsChannelSnapshot = new FsChannelSnapshot(this.id, this.raf, this.lastWrittenPosition, this.operationCounter);
            return fsChannelSnapshot;
        }
        catch (IOException e) {
            throw new TranslogException(this.shardId, "failed to flush", (Throwable)e);
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @Override
    public boolean syncNeeded() {
        return this.lastPosition != this.lastSyncPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() {
        try {
            long last = this.lastPosition;
            if (last == this.lastSyncPosition) {
                return;
            }
            this.lastSyncPosition = last;
            this.rwl.writeLock().lock();
            try {
                this.flushBuffer();
            }
            finally {
                this.rwl.writeLock().unlock();
            }
            this.raf.channel().force(false);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    public void close(boolean delete) {
        if (!delete) {
            this.rwl.writeLock().lock();
            try {
                this.flushBuffer();
                this.sync();
            }
            catch (IOException e) {
                throw new TranslogException(this.shardId, "failed to close", (Throwable)e);
            }
            finally {
                this.rwl.writeLock().unlock();
            }
        }
        this.raf.decreaseRefCount(delete);
    }

    @Override
    public void reuse(FsTranslogFile other) {
        if (!(other instanceof BufferingFsTranslogFile)) {
            return;
        }
        this.rwl.writeLock().lock();
        try {
            this.flushBuffer();
            this.buffer = ((BufferingFsTranslogFile)other).buffer;
        }
        catch (IOException e) {
            throw new TranslogException(this.shardId, "failed to flush", (Throwable)e);
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }
}

