/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.QueryBuilderException;

public class MoreLikeThisQueryBuilder
extends BaseQueryBuilder
implements BoostableQueryBuilder<MoreLikeThisQueryBuilder> {
    private final String[] fields;
    private String likeText;
    private float percentTermsToMatch = -1.0f;
    private int minTermFreq = -1;
    private int maxQueryTerms = -1;
    private String[] stopWords = null;
    private int minDocFreq = -1;
    private int maxDocFreq = -1;
    private int minWordLen = -1;
    private int maxWordLen = -1;
    private float boostTerms = -1.0f;
    private float boost = -1.0f;
    private String analyzer;

    public MoreLikeThisQueryBuilder() {
        this.fields = null;
    }

    public MoreLikeThisQueryBuilder(String ... fields) {
        this.fields = fields;
    }

    public MoreLikeThisQueryBuilder likeText(String likeText) {
        this.likeText = likeText;
        return this;
    }

    public MoreLikeThisQueryBuilder percentTermsToMatch(float percentTermsToMatch) {
        this.percentTermsToMatch = percentTermsToMatch;
        return this;
    }

    public MoreLikeThisQueryBuilder minTermFreq(int minTermFreq) {
        this.minTermFreq = minTermFreq;
        return this;
    }

    public MoreLikeThisQueryBuilder maxQueryTerms(int maxQueryTerms) {
        this.maxQueryTerms = maxQueryTerms;
        return this;
    }

    public MoreLikeThisQueryBuilder stopWords(String ... stopWords) {
        this.stopWords = stopWords;
        return this;
    }

    public MoreLikeThisQueryBuilder minDocFreq(int minDocFreq) {
        this.minDocFreq = minDocFreq;
        return this;
    }

    public MoreLikeThisQueryBuilder maxDocFreq(int maxDocFreq) {
        this.maxDocFreq = maxDocFreq;
        return this;
    }

    public MoreLikeThisQueryBuilder minWordLen(int minWordLen) {
        this.minWordLen = minWordLen;
        return this;
    }

    public MoreLikeThisQueryBuilder maxWordLen(int maxWordLen) {
        this.maxWordLen = maxWordLen;
        return this;
    }

    public MoreLikeThisQueryBuilder boostTerms(float boostTerms) {
        this.boostTerms = boostTerms;
        return this;
    }

    public MoreLikeThisQueryBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    @Override
    public MoreLikeThisQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("mlt");
        if (this.fields != null) {
            builder.startArray("fields");
            for (String field : this.fields) {
                builder.value(field);
            }
            builder.endArray();
        }
        if (this.likeText == null) {
            throw new QueryBuilderException("moreLikeThis requires 'likeText' to be provided");
        }
        builder.field("like_text", this.likeText);
        if (this.percentTermsToMatch != -1.0f) {
            builder.field("percent_terms_to_match", this.percentTermsToMatch);
        }
        if (this.minTermFreq != -1) {
            builder.field("min_term_freq", this.minTermFreq);
        }
        if (this.maxQueryTerms != -1) {
            builder.field("max_query_terms", this.maxQueryTerms);
        }
        if (this.stopWords != null && this.stopWords.length > 0) {
            builder.startArray("stop_words");
            for (String stopWord : this.stopWords) {
                builder.value(stopWord);
            }
            builder.endArray();
        }
        if (this.minDocFreq != -1) {
            builder.field("min_doc_freq", this.minDocFreq);
        }
        if (this.maxDocFreq != -1) {
            builder.field("max_doc_freq", this.maxDocFreq);
        }
        if (this.minWordLen != -1) {
            builder.field("min_word_len", this.minWordLen);
        }
        if (this.maxWordLen != -1) {
            builder.field("max_word_len", this.maxWordLen);
        }
        if (this.boostTerms != -1.0f) {
            builder.field("boost_terms", this.boostTerms);
        }
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        if (this.analyzer != null) {
            builder.field("analyzer", this.analyzer);
        }
        builder.endObject();
    }
}

