/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.search.child.ChildrenQuery;
import org.elasticsearch.index.search.child.HasChildFilter;
import org.elasticsearch.index.search.child.ScoreType;
import org.elasticsearch.search.internal.SearchContext;

public class HasChildQueryParser
implements QueryParser {
    public static final String NAME = "has_child";

    @Inject
    public HasChildQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        Query query;
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        Query innerQuery = null;
        boolean queryFound = false;
        float boost = 1.0f;
        String childType = null;
        String scope = null;
        ScoreType scoreType = null;
        String executionType = "uid";
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("query".equals(currentFieldName)) {
                    String[] stringArray;
                    if (childType == null) {
                        stringArray = null;
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = childType;
                    }
                    String[] origTypes = QueryParseContext.setTypesWithPrevious(stringArray);
                    try {
                        innerQuery = parseContext.parseInnerQuery();
                        queryFound = true;
                        continue;
                    }
                    finally {
                        QueryParseContext.setTypes(origTypes);
                        continue;
                    }
                }
                throw new QueryParsingException(parseContext.index(), "[has_child] query does not support [" + currentFieldName + "]");
            }
            if (!token.isValue()) continue;
            if ("type".equals(currentFieldName) || "child_type".equals(currentFieldName) || "childType".equals(currentFieldName)) {
                childType = parser.text();
                continue;
            }
            if ("_scope".equals(currentFieldName)) {
                scope = parser.text();
                continue;
            }
            if ("execution_type".equals(currentFieldName) || "executionType".equals(currentFieldName)) {
                scoreType = ScoreType.fromString(parser.text());
                continue;
            }
            if ("score_type".equals(currentFieldName) || "scoreType".equals(currentFieldName)) {
                String scoreTypeValue = parser.text();
                if ("none".equals(scoreTypeValue)) continue;
                scoreType = ScoreType.fromString(scoreTypeValue);
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[has_child] query does not support [" + currentFieldName + "]");
        }
        if (!queryFound) {
            throw new QueryParsingException(parseContext.index(), "[has_child] requires 'query' field");
        }
        if (innerQuery == null) {
            return null;
        }
        if (childType == null) {
            throw new QueryParsingException(parseContext.index(), "[has_child] requires 'type' field");
        }
        innerQuery.setBoost(boost);
        DocumentMapper childDocMapper = parseContext.mapperService().documentMapper(childType);
        if (childDocMapper == null) {
            throw new QueryParsingException(parseContext.index(), "[has_child] No mapping for for type [" + childType + "]");
        }
        if (childDocMapper.parentFieldMapper() == null) {
            throw new QueryParsingException(parseContext.index(), "[has_child]  Type [" + childType + "] does not have parent mapping");
        }
        String parentType = childDocMapper.parentFieldMapper().type();
        DocumentMapper parentDocMapper = parseContext.mapperService().documentMapper(parentType);
        SearchContext searchContext = SearchContext.current();
        if (scoreType != null) {
            Filter parentFilter = parseContext.cacheFilter(parentDocMapper.typeFilter(), null);
            ChildrenQuery childrenQuery = new ChildrenQuery(searchContext, parentType, childType, parentFilter, scope, innerQuery, scoreType);
            searchContext.addScopePhase(childrenQuery);
            query = childrenQuery;
        } else {
            HasChildFilter hasChildFilter = HasChildFilter.create(innerQuery, scope, parentType, childType, searchContext, executionType);
            searchContext.addScopePhase(hasChildFilter);
            query = new ConstantScoreQuery(hasChildFilter);
        }
        query.setBoost(boost);
        return query;
    }
}

