/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

public class DisMaxQueryParser
implements QueryParser {
    public static final String NAME = "dis_max";

    @Inject
    public DisMaxQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        Query query;
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        float boost = 1.0f;
        float tieBreaker = 0.0f;
        ArrayList<Query> queries = Lists.newArrayList();
        boolean queriesFound = false;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("queries".equals(currentFieldName)) {
                    queriesFound = true;
                    query = parseContext.parseInnerQuery();
                    if (query == null) continue;
                    queries.add(query);
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[dis_max] query does not support [" + currentFieldName + "]");
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if ("queries".equals(currentFieldName)) {
                    queriesFound = true;
                    while (token != XContentParser.Token.END_ARRAY) {
                        query = parseContext.parseInnerQuery();
                        if (query != null) {
                            queries.add(query);
                        }
                        token = parser.nextToken();
                    }
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[dis_max] query does not support [" + currentFieldName + "]");
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if ("tie_breaker".equals(currentFieldName) || "tieBreaker".equals(currentFieldName)) {
                tieBreaker = parser.floatValue();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[dis_max] query does not support [" + currentFieldName + "]");
        }
        if (!queriesFound) {
            throw new QueryParsingException(parseContext.index(), "[dis_max] requires 'queries' field");
        }
        if (queries.isEmpty()) {
            return null;
        }
        query = new DisjunctionMaxQuery(queries, tieBreaker);
        query.setBoost(boost);
        return query;
    }
}

