/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.search.BooleanClause;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;

public class BoolFilterBuilder
extends BaseFilterBuilder {
    private ArrayList<Clause> clauses = new ArrayList();
    private Boolean cache;
    private String cacheKey;
    private String filterName;

    public BoolFilterBuilder must(FilterBuilder filterBuilder) {
        this.clauses.add(new Clause(filterBuilder, BooleanClause.Occur.MUST));
        return this;
    }

    public BoolFilterBuilder mustNot(FilterBuilder filterBuilder) {
        this.clauses.add(new Clause(filterBuilder, BooleanClause.Occur.MUST_NOT));
        return this;
    }

    public BoolFilterBuilder should(FilterBuilder ... filterBuilders) {
        for (FilterBuilder filterBuilder : filterBuilders) {
            this.clauses.add(new Clause(filterBuilder, BooleanClause.Occur.SHOULD));
        }
        return this;
    }

    public BoolFilterBuilder must(FilterBuilder ... filterBuilders) {
        for (FilterBuilder filterBuilder : filterBuilders) {
            this.clauses.add(new Clause(filterBuilder, BooleanClause.Occur.MUST));
        }
        return this;
    }

    public BoolFilterBuilder mustNot(FilterBuilder ... filterBuilders) {
        for (FilterBuilder filterBuilder : filterBuilders) {
            this.clauses.add(new Clause(filterBuilder, BooleanClause.Occur.MUST_NOT));
        }
        return this;
    }

    public BoolFilterBuilder should(FilterBuilder filterBuilder) {
        this.clauses.add(new Clause(filterBuilder, BooleanClause.Occur.SHOULD));
        return this;
    }

    public BoolFilterBuilder filterName(String filterName) {
        this.filterName = filterName;
        return this;
    }

    public BoolFilterBuilder cache(boolean cache) {
        this.cache = cache;
        return this;
    }

    public BoolFilterBuilder cacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("bool");
        for (Clause clause : this.clauses) {
            if (clause.occur == BooleanClause.Occur.MUST) {
                builder.field("must");
                clause.filterBuilder.toXContent(builder, params);
                continue;
            }
            if (clause.occur == BooleanClause.Occur.MUST_NOT) {
                builder.field("must_not");
                clause.filterBuilder.toXContent(builder, params);
                continue;
            }
            if (clause.occur != BooleanClause.Occur.SHOULD) continue;
            builder.field("should");
            clause.filterBuilder.toXContent(builder, params);
        }
        if (this.filterName != null) {
            builder.field("_name", this.filterName);
        }
        if (this.cache != null) {
            builder.field("_cache", (Object)this.cache);
        }
        if (this.cacheKey != null) {
            builder.field("_cache_key", this.cacheKey);
        }
        builder.endObject();
    }

    private static class Clause {
        final FilterBuilder filterBuilder;
        final BooleanClause.Occur occur;

        private Clause(FilterBuilder filterBuilder, BooleanClause.Occur occur) {
            this.filterBuilder = filterBuilder;
            this.occur = occur;
        }
    }
}

