/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.geo;

import com.spatial4j.core.context.SpatialContext;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.FieldInfo;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.geo.GeoJSONShapeParser;
import org.elasticsearch.common.geo.GeoShapeConstants;
import org.elasticsearch.common.lucene.spatial.SpatialStrategy;
import org.elasticsearch.common.lucene.spatial.prefix.TermQueryPrefixTreeStrategy;
import org.elasticsearch.common.lucene.spatial.prefix.tree.GeohashPrefixTree;
import org.elasticsearch.common.lucene.spatial.prefix.tree.QuadPrefixTree;
import org.elasticsearch.common.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;

public class GeoShapeFieldMapper
extends AbstractFieldMapper<String> {
    public static final String CONTENT_TYPE = "geo_shape";
    private final SpatialStrategy spatialStrategy;

    public GeoShapeFieldMapper(FieldMapper.Names names, SpatialPrefixTree prefixTree, double distanceErrorPct) {
        super(names, Field.Index.NOT_ANALYZED, Field.Store.NO, Field.TermVector.NO, 1.0f, true, FieldInfo.IndexOptions.DOCS_ONLY, null, null);
        this.spatialStrategy = new TermQueryPrefixTreeStrategy(names, prefixTree, distanceErrorPct);
    }

    @Override
    protected Fieldable parseCreateField(ParseContext context) throws IOException {
        return this.spatialStrategy.createField(GeoJSONShapeParser.parse(context.parser()));
    }

    @Override
    protected void doXContentBody(XContentBuilder builder) throws IOException {
        builder.field("type", this.contentType());
        if (this.spatialStrategy.getPrefixTree() instanceof GeohashPrefixTree) {
            if (this.spatialStrategy.getPrefixTree().getMaxLevels() != Defaults.GEOHASH_LEVELS) {
                builder.field("tree_levels", this.spatialStrategy.getPrefixTree().getMaxLevels());
            }
        } else {
            builder.field("tree", "quadtree");
            if (this.spatialStrategy.getPrefixTree().getMaxLevels() != 12) {
                builder.field("tree_levels", this.spatialStrategy.getPrefixTree().getMaxLevels());
            }
        }
        if (this.spatialStrategy.getDistanceErrorPct() != 0.025) {
            builder.field("distance_error_pct", this.spatialStrategy.getDistanceErrorPct());
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public String value(Fieldable field) {
        throw new UnsupportedOperationException("GeoShape fields cannot be converted to String values");
    }

    @Override
    public String valueFromString(String value) {
        throw new UnsupportedOperationException("GeoShape fields cannot be converted to String values");
    }

    @Override
    public String valueAsString(Fieldable field) {
        throw new UnsupportedOperationException("GeoShape fields cannot be converted to String values");
    }

    public SpatialStrategy spatialStrategy() {
        return this.spatialStrategy;
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if ("tree".equals(fieldName)) {
                    builder.tree(fieldNode.toString());
                    continue;
                }
                if ("tree_levels".equals(fieldName)) {
                    builder.treeLevels(Integer.parseInt(fieldNode.toString()));
                    continue;
                }
                if (!"distance_error_pct".equals(fieldName)) continue;
                builder.distanceErrorPct(Double.parseDouble(fieldNode.toString()));
            }
            return builder;
        }
    }

    public static class Builder
    extends AbstractFieldMapper.Builder<Builder, GeoShapeFieldMapper> {
        private String tree = "geohash";
        private int treeLevels;
        private double distanceErrorPct = 0.025;
        private SpatialPrefixTree prefixTree;

        public Builder(String name) {
            super(name);
        }

        public Builder tree(String tree) {
            this.tree = tree;
            return this;
        }

        public Builder treeLevels(int treeLevels) {
            this.treeLevels = treeLevels;
            return this;
        }

        public Builder distanceErrorPct(double distanceErrorPct) {
            this.distanceErrorPct = distanceErrorPct;
            return this;
        }

        @Override
        public GeoShapeFieldMapper build(Mapper.BuilderContext context) {
            if (this.tree.equals("geohash")) {
                int levels = this.treeLevels != 0 ? this.treeLevels : Defaults.GEOHASH_LEVELS;
                this.prefixTree = new GeohashPrefixTree((SpatialContext)GeoShapeConstants.SPATIAL_CONTEXT, levels);
            } else if (this.tree.equals("quadtree")) {
                int levels = this.treeLevels != 0 ? this.treeLevels : 12;
                this.prefixTree = new QuadPrefixTree((SpatialContext)GeoShapeConstants.SPATIAL_CONTEXT, levels);
            } else {
                throw new ElasticSearchIllegalArgumentException("Unknown prefix tree type [" + this.tree + "]");
            }
            return new GeoShapeFieldMapper(this.buildNames(context), this.prefixTree, this.distanceErrorPct);
        }
    }

    public static class Defaults {
        public static final String TREE = "geohash";
        public static final int GEOHASH_LEVELS = GeohashPrefixTree.getMaxLevelsPossible();
        public static final int QUADTREE_LEVELS = 12;
        public static final double DISTANCE_ERROR_PCT = 0.025;
    }

    public static class Names {
        public static final String TREE = "tree";
        public static final String TREE_LEVELS = "tree_levels";
        public static final String GEOHASH = "geohash";
        public static final String QUADTREE = "quadtree";
        public static final String DISTANCE_ERROR_PCT = "distance_error_pct";
    }
}

