/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.indexing.slowlog;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;

public class ShardSlowLogIndexingService
extends AbstractIndexShardComponent {
    private boolean reformat;
    private long indexWarnThreshold;
    private long indexInfoThreshold;
    private long indexDebugThreshold;
    private long indexTraceThreshold;
    private String level;
    private final ESLogger indexLogger;
    private final ESLogger deleteLogger;

    @Inject
    public ShardSlowLogIndexingService(ShardId shardId, @IndexSettings Settings indexSettings, IndexSettingsService indexSettingsService) {
        super(shardId, indexSettings);
        this.reformat = this.componentSettings.getAsBoolean("reformat", true);
        this.indexWarnThreshold = this.componentSettings.getAsTime("threshold.index.warn", TimeValue.timeValueNanos(-1L)).nanos();
        this.indexInfoThreshold = this.componentSettings.getAsTime("threshold.index.info", TimeValue.timeValueNanos(-1L)).nanos();
        this.indexDebugThreshold = this.componentSettings.getAsTime("threshold.index.debug", TimeValue.timeValueNanos(-1L)).nanos();
        this.indexTraceThreshold = this.componentSettings.getAsTime("threshold.index.trace", TimeValue.timeValueNanos(-1L)).nanos();
        this.level = this.componentSettings.get("level", "TRACE").toUpperCase();
        this.indexLogger = Loggers.getLogger(this.logger, ".index");
        this.deleteLogger = Loggers.getLogger(this.logger, ".delete");
        this.indexLogger.setLevel(this.level);
        this.deleteLogger.setLevel(this.level);
        indexSettingsService.addListener(new ApplySettings());
    }

    public void postIndex(Engine.Index index, long tookInNanos) {
        this.postIndexing(index.parsedDoc(), tookInNanos);
    }

    public void postCreate(Engine.Create create, long tookInNanos) {
        this.postIndexing(create.parsedDoc(), tookInNanos);
    }

    private void postIndexing(ParsedDocument doc, long tookInNanos) {
        if (this.indexWarnThreshold >= 0L && tookInNanos > this.indexWarnThreshold) {
            this.indexLogger.warn("{}", new SlowLogParsedDocumentPrinter(doc, tookInNanos, this.reformat));
        } else if (this.indexInfoThreshold >= 0L && tookInNanos > this.indexInfoThreshold) {
            this.indexLogger.info("{}", new SlowLogParsedDocumentPrinter(doc, tookInNanos, this.reformat));
        } else if (this.indexDebugThreshold >= 0L && tookInNanos > this.indexDebugThreshold) {
            this.indexLogger.debug("{}", new SlowLogParsedDocumentPrinter(doc, tookInNanos, this.reformat));
        } else if (this.indexTraceThreshold >= 0L && tookInNanos > this.indexTraceThreshold) {
            this.indexLogger.trace("{}", new SlowLogParsedDocumentPrinter(doc, tookInNanos, this.reformat));
        }
    }

    static {
        IndexMetaData.addDynamicSettings("index.indexing.slowlog.threshold.index.warn", "index.indexing.slowlog.threshold.index.info", "index.indexing.slowlog.threshold.index.debug", "index.indexing.slowlog.threshold.index.trace", "index.indexing.slowlog.reformat", "index.indexing.slowlog.level");
    }

    public static class SlowLogParsedDocumentPrinter {
        private final ParsedDocument doc;
        private final long tookInNanos;
        private final boolean reformat;

        public SlowLogParsedDocumentPrinter(ParsedDocument doc, long tookInNanos, boolean reformat) {
            this.doc = doc;
            this.tookInNanos = tookInNanos;
            this.reformat = reformat;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("took[").append(TimeValue.timeValueNanos(this.tookInNanos)).append("], took_millis[").append(TimeUnit.NANOSECONDS.toMillis(this.tookInNanos)).append("], ");
            sb.append("type[").append(this.doc.type()).append("], ");
            sb.append("id[").append(this.doc.id()).append("], ");
            if (this.doc.routing() == null) {
                sb.append("routing[], ");
            } else {
                sb.append("routing[").append(this.doc.routing()).append("], ");
            }
            if (this.doc.source() != null && this.doc.source().length() > 0) {
                try {
                    sb.append("source[").append(XContentHelper.convertToJson(this.doc.source(), this.reformat)).append("]");
                }
                catch (IOException e) {
                    sb.append("source[_failed_to_convert_]");
                }
            } else {
                sb.append("source[]");
            }
            return sb.toString();
        }
    }

    class ApplySettings
    implements IndexSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public synchronized void onRefreshSettings(Settings settings) {
            boolean reformat;
            String level;
            long indexTraceThreshold;
            long indexDebugThreshold;
            long indexInfoThreshold;
            long indexWarnThreshold = settings.getAsTime("index.indexing.slowlog.threshold.index.warn", TimeValue.timeValueNanos(ShardSlowLogIndexingService.this.indexWarnThreshold)).nanos();
            if (indexWarnThreshold != ShardSlowLogIndexingService.this.indexWarnThreshold) {
                ShardSlowLogIndexingService.this.indexWarnThreshold = indexWarnThreshold;
            }
            if ((indexInfoThreshold = settings.getAsTime("index.indexing.slowlog.threshold.index.info", TimeValue.timeValueNanos(ShardSlowLogIndexingService.this.indexInfoThreshold)).nanos()) != ShardSlowLogIndexingService.this.indexInfoThreshold) {
                ShardSlowLogIndexingService.this.indexInfoThreshold = indexInfoThreshold;
            }
            if ((indexDebugThreshold = settings.getAsTime("index.indexing.slowlog.threshold.index.debug", TimeValue.timeValueNanos(ShardSlowLogIndexingService.this.indexDebugThreshold)).nanos()) != ShardSlowLogIndexingService.this.indexDebugThreshold) {
                ShardSlowLogIndexingService.this.indexDebugThreshold = indexDebugThreshold;
            }
            if ((indexTraceThreshold = settings.getAsTime("index.indexing.slowlog.threshold.index.trace", TimeValue.timeValueNanos(ShardSlowLogIndexingService.this.indexTraceThreshold)).nanos()) != ShardSlowLogIndexingService.this.indexTraceThreshold) {
                ShardSlowLogIndexingService.this.indexTraceThreshold = indexTraceThreshold;
            }
            if (!(level = settings.get("index.indexing.slowlog.level", ShardSlowLogIndexingService.this.level)).equals(ShardSlowLogIndexingService.this.level)) {
                ShardSlowLogIndexingService.this.indexLogger.setLevel(level.toUpperCase());
                ShardSlowLogIndexingService.this.deleteLogger.setLevel(level.toUpperCase());
                ShardSlowLogIndexingService.this.level = level;
            }
            if ((reformat = settings.getAsBoolean("index.indexing.slowlog.reformat", ShardSlowLogIndexingService.this.reformat).booleanValue()) != ShardSlowLogIndexingService.this.reformat) {
                ShardSlowLogIndexingService.this.reformat = reformat;
            }
        }
    }
}

