/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.common.util.concurrent.ThreadLocals;
import org.elasticsearch.index.field.data.DocFieldData;
import org.elasticsearch.index.field.data.FieldDataType;

public abstract class FieldData<Doc extends DocFieldData> {
    private final ThreadLocal<ThreadLocals.CleanableValue<Doc>> cachedDocFieldData = new ThreadLocal<ThreadLocals.CleanableValue<Doc>>(){

        @Override
        protected ThreadLocals.CleanableValue<Doc> initialValue() {
            return new ThreadLocals.CleanableValue(FieldData.this.createFieldData());
        }
    };
    private final String fieldName;
    private long sizeInBytes = -1L;

    protected FieldData(String fieldName) {
        this.fieldName = fieldName;
    }

    public final String fieldName() {
        return this.fieldName;
    }

    public Doc docFieldData(int docId) {
        DocFieldData docFieldData = (DocFieldData)this.cachedDocFieldData.get().get();
        docFieldData.setDocId(docId);
        return (Doc)docFieldData;
    }

    public long sizeInBytes() {
        if (this.sizeInBytes == -1L) {
            this.sizeInBytes = this.computeSizeInBytes();
        }
        return this.sizeInBytes;
    }

    protected abstract long computeSizeInBytes();

    protected abstract Doc createFieldData();

    public abstract boolean multiValued();

    public abstract boolean hasValue(int var1);

    public abstract String stringValue(int var1);

    public abstract void forEachValue(StringValueProc var1);

    public abstract void forEachValueInDoc(int var1, StringValueInDocProc var2);

    public abstract void forEachOrdinalInDoc(int var1, OrdinalInDocProc var2);

    public abstract FieldDataType type();

    public static FieldData load(FieldDataType type, IndexReader reader, String fieldName) throws IOException {
        return type.load(reader, fieldName);
    }

    public static interface OrdinalInDocProc {
        public void onOrdinal(int var1, int var2);
    }

    public static interface StringValueInDocProc {
        public void onValue(int var1, String var2);

        public void onMissing(int var1);
    }

    public static interface StringValueProc {
        public void onValue(String var1);
    }
}

