/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.elasticsearch.index.analysis.NumericTokenizer;

public abstract class NumericAnalyzer<T extends NumericTokenizer>
extends Analyzer {
    @Override
    public final TokenStream tokenStream(String fieldName, Reader reader) {
        try {
            return this.createNumericTokenizer(reader, new char[32]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create numeric tokenizer", e);
        }
    }

    @Override
    public final TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        Holder holder = (Holder)this.getPreviousTokenStream();
        if (holder == null) {
            char[] buffer = new char[120];
            holder = new Holder((NumericTokenizer)this.createNumericTokenizer(reader, buffer), buffer);
            this.setPreviousTokenStream(holder);
        } else {
            holder.tokenizer.reset(reader, holder.buffer);
        }
        return holder.tokenizer;
    }

    protected abstract T createNumericTokenizer(Reader var1, char[] var2) throws IOException;

    private static final class Holder {
        final NumericTokenizer tokenizer;
        final char[] buffer;

        private Holder(NumericTokenizer tokenizer, char[] buffer) {
            this.tokenizer = tokenizer;
            this.buffer = buffer;
        }
    }
}

