/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import org.elasticsearch.common.component.CloseableComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.jmx.JmxService;
import org.elasticsearch.jmx.MBean;
import org.elasticsearch.jmx.ManagedAttribute;

@MBean(objectName="", description="")
public class IndexServiceManagement
extends AbstractIndexComponent
implements CloseableComponent {
    private final JmxService jmxService;
    private final IndexService indexService;

    public static String buildIndexGroupName(Index index) {
        return "service=indices,index=" + index.name();
    }

    @Inject
    public IndexServiceManagement(Index index, @IndexSettings Settings indexSettings, JmxService jmxService, IndexService indexService) {
        super(index, indexSettings);
        this.jmxService = jmxService;
        this.indexService = indexService;
    }

    @Override
    public void close() {
        this.jmxService.unregisterGroup(IndexServiceManagement.buildIndexGroupName(this.indexService.index()));
    }

    @ManagedAttribute(description="Index Name")
    public String getIndex() {
        return this.indexService.index().name();
    }
}

