/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.spatial.prefix.tree;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.io.GeohashUtils;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.common.lucene.spatial.prefix.tree.Node;
import org.elasticsearch.common.lucene.spatial.prefix.tree.SpatialPrefixTree;

public class GeohashPrefixTree
extends SpatialPrefixTree {
    public GeohashPrefixTree(SpatialContext ctx, int maxLevels) {
        super(ctx, maxLevels);
        Rectangle bounds = ctx.getWorldBounds();
        if (bounds.getMinX() != -180.0) {
            throw new IllegalArgumentException("Geohash only supports lat-lon world bounds. Got " + bounds);
        }
        int MAXP = GeohashPrefixTree.getMaxLevelsPossible();
        if (maxLevels <= 0 || maxLevels > MAXP) {
            throw new IllegalArgumentException("maxLen must be [1-" + MAXP + "] but got " + maxLevels);
        }
    }

    public static int getMaxLevelsPossible() {
        return 24;
    }

    @Override
    public int getLevelForDistance(double dist) {
        if (dist == 0.0) {
            return this.maxLevels;
        }
        int level = GeohashUtils.lookupHashLenForWidthHeight((double)dist, (double)dist);
        return Math.max(Math.min(level, this.maxLevels), 1);
    }

    @Override
    public Node getNode(Point p, int level) {
        return new GhCell(GeohashUtils.encodeLatLon((double)p.getY(), (double)p.getX(), (int)level));
    }

    @Override
    public Node getNode(String token) {
        return new GhCell(token);
    }

    @Override
    public Node getNode(byte[] bytes, int offset, int len) {
        return new GhCell(bytes, offset, len);
    }

    @Override
    public List<Node> getNodes(Shape shape, int detailLevel, boolean inclParents) {
        return shape instanceof Point ? super.getNodesAltPoint((Point)shape, detailLevel, inclParents) : super.getNodes(shape, detailLevel, inclParents);
    }

    class GhCell
    extends Node {
        private Shape shape;

        GhCell(String token) {
            super(GeohashPrefixTree.this, token);
        }

        GhCell(byte[] bytes, int off, int len) {
            super(GeohashPrefixTree.this, bytes, off, len);
        }

        @Override
        public void reset(byte[] bytes, int off, int len) {
            super.reset(bytes, off, len);
            this.shape = null;
        }

        @Override
        public Collection<Node> getSubCells() {
            String[] hashes = GeohashUtils.getSubGeohashes((String)this.getGeohash());
            ArrayList<Node> cells = new ArrayList<Node>(hashes.length);
            for (String hash : hashes) {
                cells.add(new GhCell(hash));
            }
            return cells;
        }

        @Override
        public int getSubCellsSize() {
            return 32;
        }

        @Override
        public Node getSubCell(Point p) {
            return GeohashPrefixTree.this.getNode(p, this.getLevel() + 1);
        }

        @Override
        public Shape getShape() {
            if (this.shape == null) {
                this.shape = GeohashUtils.decodeBoundary((String)this.getGeohash(), (SpatialContext)GeohashPrefixTree.this.ctx);
            }
            return this.shape;
        }

        @Override
        public Point getCenter() {
            return GeohashUtils.decode((String)this.getGeohash(), (SpatialContext)GeohashPrefixTree.this.ctx);
        }

        private String getGeohash() {
            return this.getTokenString();
        }
    }
}

