/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ScoreCachingWrappingScorer;
import org.apache.lucene.search.Scorer;

public class MinimumScoreCollector
extends Collector {
    private final Collector collector;
    private final float minimumScore;
    private Scorer scorer;

    public MinimumScoreCollector(Collector collector, float minimumScore) {
        this.collector = collector;
        this.minimumScore = minimumScore;
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        if (!(scorer instanceof ScoreCachingWrappingScorer)) {
            scorer = new ScoreCachingWrappingScorer(scorer);
        }
        this.scorer = scorer;
        this.collector.setScorer(scorer);
    }

    @Override
    public void collect(int doc) throws IOException {
        if (this.scorer.score() > this.minimumScore) {
            this.collector.collect(doc);
        }
    }

    @Override
    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.collector.setNextReader(reader, docBase);
    }

    @Override
    public boolean acceptsDocsOutOfOrder() {
        return this.collector.acceptsDocsOutOfOrder();
    }
}

