/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging.log4j;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.elasticsearch.common.logging.support.AbstractESLogger;

public class Log4jESLogger
extends AbstractESLogger {
    private final Logger logger;

    public Log4jESLogger(String prefix, Logger logger) {
        super(prefix);
        this.logger = logger;
    }

    @Override
    public void setLevel(String level) {
        if ("error".equalsIgnoreCase(level)) {
            this.logger.setLevel(Level.ERROR);
        } else if ("warn".equalsIgnoreCase(level)) {
            this.logger.setLevel(Level.WARN);
        } else if ("info".equalsIgnoreCase(level)) {
            this.logger.setLevel(Level.INFO);
        } else if ("debug".equalsIgnoreCase(level)) {
            this.logger.setLevel(Level.DEBUG);
        } else if ("trace".equalsIgnoreCase(level)) {
            this.logger.setLevel(Level.TRACE);
        }
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    @Override
    protected void internalTrace(String msg) {
        this.logger.trace((Object)msg);
    }

    @Override
    protected void internalTrace(String msg, Throwable cause) {
        this.logger.trace((Object)msg, cause);
    }

    @Override
    protected void internalDebug(String msg) {
        this.logger.debug((Object)msg);
    }

    @Override
    protected void internalDebug(String msg, Throwable cause) {
        this.logger.debug((Object)msg, cause);
    }

    @Override
    protected void internalInfo(String msg) {
        this.logger.info((Object)msg);
    }

    @Override
    protected void internalInfo(String msg, Throwable cause) {
        this.logger.info((Object)msg, cause);
    }

    @Override
    protected void internalWarn(String msg) {
        this.logger.warn((Object)msg);
    }

    @Override
    protected void internalWarn(String msg, Throwable cause) {
        this.logger.warn((Object)msg, cause);
    }

    @Override
    protected void internalError(String msg) {
        this.logger.error((Object)msg);
    }

    @Override
    protected void internalError(String msg, Throwable cause) {
        this.logger.error((Object)msg, cause);
    }
}

