/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.impl.PointImpl;
import com.spatial4j.core.shape.impl.RectangleImpl;
import com.spatial4j.core.shape.jts.JtsGeometry;
import com.spatial4j.core.shape.jts.JtsPoint;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.geo.GeoShapeConstants;

public class ShapeBuilder {
    private static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();

    private ShapeBuilder() {
    }

    public static Point newPoint(double lon, double lat) {
        return new PointImpl(lon, lat, (SpatialContext)GeoShapeConstants.SPATIAL_CONTEXT);
    }

    public static RectangleBuilder newRectangle() {
        return new RectangleBuilder();
    }

    public static PolygonBuilder newPolygon() {
        return new PolygonBuilder();
    }

    public static Geometry toJTSGeometry(Shape shape) {
        if (shape instanceof JtsGeometry) {
            return ((JtsGeometry)shape).getGeom();
        }
        if (shape instanceof JtsPoint) {
            return ((JtsPoint)shape).getGeom();
        }
        if (shape instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)shape;
            if (rectangle.getCrossesDateLine()) {
                throw new IllegalArgumentException("Cannot convert Rectangles that cross the dateline into JTS Geometrys");
            }
            return ShapeBuilder.newPolygon().point(rectangle.getMinX(), rectangle.getMaxY()).point(rectangle.getMaxX(), rectangle.getMaxY()).point(rectangle.getMaxX(), rectangle.getMinY()).point(rectangle.getMinX(), rectangle.getMinY()).point(rectangle.getMinX(), rectangle.getMaxY()).toPolygon();
        }
        if (shape instanceof Point) {
            Point point = (Point)shape;
            return GEOMETRY_FACTORY.createPoint(new Coordinate(point.getX(), point.getY()));
        }
        throw new IllegalArgumentException("Shape type [" + shape.getClass().getSimpleName() + "] not supported");
    }

    public static class PolygonBuilder {
        private final List<Point> points = new ArrayList<Point>();

        public PolygonBuilder point(double lon, double lat) {
            this.points.add((Point)new PointImpl(lon, lat, (SpatialContext)GeoShapeConstants.SPATIAL_CONTEXT));
            return this;
        }

        public Shape build() {
            return new JtsGeometry((Geometry)this.toPolygon(), GeoShapeConstants.SPATIAL_CONTEXT, true);
        }

        public Polygon toPolygon() {
            Coordinate[] coordinates = new Coordinate[this.points.size()];
            for (int i = 0; i < this.points.size(); ++i) {
                coordinates[i] = new Coordinate(this.points.get(i).getX(), this.points.get(i).getY());
            }
            LinearRing ring = GEOMETRY_FACTORY.createLinearRing(coordinates);
            return GEOMETRY_FACTORY.createPolygon(ring, null);
        }
    }

    public static class RectangleBuilder {
        private Point topLeft;
        private Point bottomRight;

        public RectangleBuilder topLeft(double lon, double lat) {
            this.topLeft = new PointImpl(lon, lat, (SpatialContext)GeoShapeConstants.SPATIAL_CONTEXT);
            return this;
        }

        public RectangleBuilder bottomRight(double lon, double lat) {
            this.bottomRight = new PointImpl(lon, lat, (SpatialContext)GeoShapeConstants.SPATIAL_CONTEXT);
            return this;
        }

        public Rectangle build() {
            return new RectangleImpl(this.topLeft.getX(), this.bottomRight.getX(), this.bottomRight.getY(), this.topLeft.getY(), (SpatialContext)GeoShapeConstants.SPATIAL_CONTEXT);
        }
    }
}

