/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.snappy.xerial;

import java.io.IOException;
import org.elasticsearch.common.compress.snappy.SnappyCompressedStreamInput;
import org.elasticsearch.common.compress.snappy.SnappyCompressorContext;
import org.elasticsearch.common.io.stream.StreamInput;
import org.xerial.snappy.Snappy;

public class XerialSnappyCompressedStreamInput
extends SnappyCompressedStreamInput {
    public XerialSnappyCompressedStreamInput(StreamInput in, SnappyCompressorContext context) throws IOException {
        super(in, context);
    }

    @Override
    protected int uncompress(StreamInput in, byte[] out) throws IOException {
        int compressedByte = in.read();
        if (compressedByte == -1) {
            return 0;
        }
        boolean compressed = compressedByte == 1;
        int length = in.readVInt();
        if (!compressed) {
            in.readBytes(out, 0, length);
            return length;
        }
        in.readBytes(this.inputBuffer, 0, length);
        return Snappy.rawUncompress((byte[])this.inputBuffer, (int)0, (int)length, (Object)out, (int)0);
    }
}

