/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.snappy;

import java.io.IOException;
import org.apache.lucene.store.IndexOutput;
import org.elasticsearch.common.compress.BufferRecycler;
import org.elasticsearch.common.compress.CompressedIndexOutput;
import org.elasticsearch.common.compress.snappy.SnappyCompressor;
import org.elasticsearch.common.compress.snappy.SnappyCompressorContext;

public abstract class SnappyCompressedIndexOutput
extends CompressedIndexOutput<SnappyCompressorContext> {
    protected final BufferRecycler recycler = BufferRecycler.instance();
    protected byte[] compressedBuffer;

    public SnappyCompressedIndexOutput(IndexOutput out, SnappyCompressorContext context) throws IOException {
        super(out, context);
        this.uncompressed = this.recycler.allocOutputBuffer(context.compressChunkLength());
        this.uncompressedLength = context.compressChunkLength();
        this.compressedBuffer = this.recycler.allocEncodingBuffer(context.compressMaxCompressedChunkLength());
    }

    @Override
    protected void writeHeader(IndexOutput out) throws IOException {
        out.writeBytes(SnappyCompressor.HEADER, SnappyCompressor.HEADER.length);
        out.writeVInt(((SnappyCompressorContext)this.context).compressChunkLength());
        out.writeVInt(((SnappyCompressorContext)this.context).compressMaxCompressedChunkLength());
    }

    @Override
    protected void doClose() throws IOException {
        byte[] buf = this.uncompressed;
        if (buf != null) {
            this.uncompressed = null;
            this.recycler.releaseOutputBuffer(buf);
        }
        if ((buf = this.compressedBuffer) != null) {
            this.compressedBuffer = null;
            this.recycler.releaseEncodeBuffer(buf);
        }
    }
}

