/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.lzf;

import java.io.IOException;
import org.apache.lucene.store.IndexOutput;
import org.elasticsearch.common.compress.BufferRecycler;
import org.elasticsearch.common.compress.CompressedIndexOutput;
import org.elasticsearch.common.compress.lzf.ChunkEncoder;
import org.elasticsearch.common.compress.lzf.LZFCompressor;
import org.elasticsearch.common.compress.lzf.LZFCompressorContext;
import org.elasticsearch.common.lucene.store.OutputStreamIndexOutput;

public class LZFCompressedIndexOutput
extends CompressedIndexOutput<LZFCompressorContext> {
    private final BufferRecycler recycler = BufferRecycler.instance();
    private final ChunkEncoder encoder;

    public LZFCompressedIndexOutput(IndexOutput out) throws IOException {
        super(out, LZFCompressorContext.INSTANCE);
        this.uncompressed = this.recycler.allocOutputBuffer(65535);
        this.uncompressedLength = 65535;
        this.encoder = new ChunkEncoder(65535);
    }

    @Override
    protected void writeHeader(IndexOutput out) throws IOException {
        out.writeBytes(LZFCompressor.LUCENE_HEADER, LZFCompressor.LUCENE_HEADER.length);
    }

    @Override
    protected void compress(byte[] data, int offset, int len, IndexOutput out) throws IOException {
        this.encoder.encodeAndWriteChunk(data, offset, len, new OutputStreamIndexOutput(out));
    }

    @Override
    protected void doClose() throws IOException {
        byte[] buf = this.uncompressed;
        if (buf != null) {
            this.uncompressed = null;
            this.recycler.releaseOutputBuffer(buf);
        }
        this.encoder.close();
    }
}

