/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.bloom;

import org.apache.lucene.util.OpenBitSet;
import org.elasticsearch.common.MurmurHash;
import org.elasticsearch.common.RamUsage;
import org.elasticsearch.common.bloom.BloomFilter;

public class ObsBloomFilter
implements BloomFilter {
    private final int hashCount;
    private final OpenBitSet bitset;
    private final long size;

    ObsBloomFilter(int hashCount, long size) {
        this.hashCount = hashCount;
        this.bitset = new OpenBitSet(size);
        this.size = size;
    }

    long emptyBuckets() {
        long n = 0L;
        for (long i = 0L; i < this.buckets(); ++i) {
            if (this.bitset.get(i)) continue;
            ++n;
        }
        return n;
    }

    private long buckets() {
        return this.size;
    }

    private long[] getHashBuckets(byte[] key, int offset, int length) {
        return ObsBloomFilter.getHashBuckets(key, offset, length, this.hashCount, this.buckets());
    }

    static long[] getHashBuckets(byte[] b, int offset, int length, int hashCount, long max) {
        long[] result = new long[hashCount];
        long[] hash = MurmurHash.hash3_x64_128(b, offset, length, 0L);
        for (int i = 0; i < hashCount; ++i) {
            result[i] = Math.abs((hash[0] + (long)i * hash[1]) % max);
        }
        return result;
    }

    @Override
    public void add(byte[] key, int offset, int length) {
        long[] hash = MurmurHash.hash3_x64_128(key, offset, length, 0L);
        for (int i = 0; i < this.hashCount; ++i) {
            long bucketIndex = Math.abs((hash[0] + (long)i * hash[1]) % this.size);
            this.bitset.fastSet(bucketIndex);
        }
    }

    @Override
    public boolean isPresent(byte[] key, int offset, int length) {
        long[] hash = MurmurHash.hash3_x64_128(key, offset, length, 0L);
        for (int i = 0; i < this.hashCount; ++i) {
            long bucketIndex = Math.abs((hash[0] + (long)i * hash[1]) % this.size);
            if (this.bitset.fastGet(bucketIndex)) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        this.bitset.clear(0L, this.bitset.size());
    }

    @Override
    public long sizeInBytes() {
        return this.bitset.getBits().length * 8 + RamUsage.NUM_BYTES_ARRAY_HEADER + 4;
    }
}

