/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.util.Set;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.AwarenessAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ClusterRebalanceAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ConcurrentRebalanceAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.cluster.routing.allocation.decider.DisableAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.FilterAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.RebalanceOnlyWhenActiveAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ReplicaAfterPrimaryActiveAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.SameShardAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ShardsLimitAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ThrottlingAllocationDecider;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.settings.NodeSettingsService;

public class AllocationDeciders
extends AllocationDecider {
    private final AllocationDecider[] allocations;

    public AllocationDeciders(Settings settings, NodeSettingsService nodeSettingsService) {
        this(settings, (Set<AllocationDecider>)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(new SameShardAllocationDecider(settings))).add(new FilterAllocationDecider(settings, nodeSettingsService))).add(new ReplicaAfterPrimaryActiveAllocationDecider(settings))).add(new ThrottlingAllocationDecider(settings, nodeSettingsService))).add(new RebalanceOnlyWhenActiveAllocationDecider(settings))).add(new ClusterRebalanceAllocationDecider(settings))).add(new ConcurrentRebalanceAllocationDecider(settings, nodeSettingsService))).add(new DisableAllocationDecider(settings, nodeSettingsService))).add(new AwarenessAllocationDecider(settings, nodeSettingsService))).add(new ShardsLimitAllocationDecider(settings))).build()));
    }

    @Inject
    public AllocationDeciders(Settings settings, Set<AllocationDecider> allocations) {
        super(settings);
        this.allocations = allocations.toArray(new AllocationDecider[allocations.size()]);
    }

    @Override
    public Decision canRebalance(ShardRouting shardRouting, RoutingAllocation allocation) {
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider allocationDecider : this.allocations) {
            Decision decision = allocationDecider.canRebalance(shardRouting, allocation);
            if (decision == Decision.ALWAYS) continue;
            ret.add(decision);
        }
        return ret;
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (allocation.shouldIgnoreShardForNode(shardRouting.shardId(), node.nodeId())) {
            return Decision.NO;
        }
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider allocationDecider : this.allocations) {
            Decision decision = allocationDecider.canAllocate(shardRouting, node, allocation);
            if (decision == Decision.ALWAYS) continue;
            ret.add(decision);
        }
        return ret;
    }

    @Override
    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (allocation.shouldIgnoreShardForNode(shardRouting.shardId(), node.nodeId())) {
            return Decision.NO;
        }
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider allocationDecider : this.allocations) {
            Decision decision = allocationDecider.canRemain(shardRouting, node, allocation);
            if (decision == Decision.ALWAYS) continue;
            ret.add(decision);
        }
        return ret;
    }
}

