/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ImmutableShardRouting;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.allocation.FailedRerouteAllocation;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.StartedRerouteAllocation;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocators;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommands;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.settings.NodeSettingsService;

public class AllocationService
extends AbstractComponent {
    private final AllocationDeciders allocationDeciders;
    private final ShardsAllocators shardsAllocators;

    public AllocationService() {
        this(ImmutableSettings.Builder.EMPTY_SETTINGS);
    }

    public AllocationService(Settings settings) {
        this(settings, new AllocationDeciders(settings, new NodeSettingsService(ImmutableSettings.Builder.EMPTY_SETTINGS)), new ShardsAllocators(settings));
    }

    @Inject
    public AllocationService(Settings settings, AllocationDeciders allocationDeciders, ShardsAllocators shardsAllocators) {
        super(settings);
        this.allocationDeciders = allocationDeciders;
        this.shardsAllocators = shardsAllocators;
    }

    public RoutingAllocation.Result applyStartedShards(ClusterState clusterState, List<? extends ShardRouting> startedShards) {
        return this.applyStartedShards(clusterState, startedShards, true);
    }

    public RoutingAllocation.Result applyStartedShards(ClusterState clusterState, List<? extends ShardRouting> startedShards, boolean withReroute) {
        RoutingNodes routingNodes = clusterState.routingNodes();
        Collections.shuffle(routingNodes.unassigned());
        StartedRerouteAllocation allocation = new StartedRerouteAllocation(this.allocationDeciders, routingNodes, clusterState.nodes(), startedShards);
        boolean changed = this.applyStartedShards(routingNodes, startedShards);
        if (!changed) {
            return new RoutingAllocation.Result(false, clusterState.routingTable(), allocation.explanation());
        }
        this.shardsAllocators.applyStartedShards(allocation);
        if (withReroute) {
            this.reroute(allocation);
        }
        return new RoutingAllocation.Result(true, new RoutingTable.Builder().updateNodes(routingNodes).build().validateRaiseException(clusterState.metaData()), allocation.explanation());
    }

    public RoutingAllocation.Result applyFailedShard(ClusterState clusterState, ShardRouting failedShard) {
        RoutingNodes routingNodes = clusterState.routingNodes();
        Collections.shuffle(routingNodes.unassigned());
        FailedRerouteAllocation allocation = new FailedRerouteAllocation(this.allocationDeciders, routingNodes, clusterState.nodes(), failedShard);
        boolean changed = this.applyFailedShard(allocation, failedShard, true);
        if (!changed) {
            return new RoutingAllocation.Result(false, clusterState.routingTable(), allocation.explanation());
        }
        this.shardsAllocators.applyFailedShards(allocation);
        this.reroute(allocation);
        return new RoutingAllocation.Result(true, new RoutingTable.Builder().updateNodes(routingNodes).build().validateRaiseException(clusterState.metaData()), allocation.explanation());
    }

    public RoutingAllocation.Result reroute(ClusterState clusterState, AllocationCommands commands) throws ElasticSearchException {
        RoutingNodes routingNodes = clusterState.routingNodes();
        RoutingAllocation allocation = new RoutingAllocation(this.allocationDeciders, routingNodes, clusterState.nodes());
        allocation.ignoreDisable(true);
        commands.execute(allocation);
        allocation.ignoreDisable(false);
        this.reroute(allocation);
        return new RoutingAllocation.Result(true, new RoutingTable.Builder().updateNodes(routingNodes).build().validateRaiseException(clusterState.metaData()), allocation.explanation());
    }

    public RoutingAllocation.Result reroute(ClusterState clusterState) {
        RoutingNodes routingNodes = clusterState.routingNodes();
        Collections.shuffle(routingNodes.unassigned());
        RoutingAllocation allocation = new RoutingAllocation(this.allocationDeciders, routingNodes, clusterState.nodes());
        if (!this.reroute(allocation)) {
            return new RoutingAllocation.Result(false, clusterState.routingTable(), allocation.explanation());
        }
        return new RoutingAllocation.Result(true, new RoutingTable.Builder().updateNodes(routingNodes).build().validateRaiseException(clusterState.metaData()), allocation.explanation());
    }

    public RoutingAllocation.Result rerouteWithNoReassign(ClusterState clusterState) {
        RoutingNodes routingNodes = clusterState.routingNodes();
        Collections.shuffle(routingNodes.unassigned());
        RoutingAllocation allocation = new RoutingAllocation(this.allocationDeciders, routingNodes, clusterState.nodes());
        Collection dataNodes = allocation.nodes().dataNodes().values();
        boolean changed = false;
        changed |= this.deassociateDeadNodes(allocation);
        this.applyNewNodes(allocation);
        if (!(changed |= this.electPrimariesAndUnassignDanglingReplicas(allocation))) {
            return new RoutingAllocation.Result(false, clusterState.routingTable(), allocation.explanation());
        }
        return new RoutingAllocation.Result(true, new RoutingTable.Builder().updateNodes(routingNodes).build().validateRaiseException(clusterState.metaData()), allocation.explanation());
    }

    private boolean reroute(RoutingAllocation allocation) {
        Collection dataNodes = allocation.nodes().dataNodes().values();
        boolean changed = false;
        changed |= this.deassociateDeadNodes(allocation);
        this.applyNewNodes(allocation);
        changed |= this.electPrimariesAndUnassignDanglingReplicas(allocation);
        if (allocation.routingNodes().hasUnassigned()) {
            changed |= this.shardsAllocators.allocateUnassigned(allocation);
            changed |= this.electPrimariesAndUnassignDanglingReplicas(allocation);
        }
        changed |= this.moveShards(allocation);
        return changed |= this.shardsAllocators.rebalance(allocation);
    }

    private boolean moveShards(RoutingAllocation allocation) {
        boolean changed = false;
        ArrayList<MutableShardRouting> shards = new ArrayList<MutableShardRouting>();
        int index = 0;
        boolean found = true;
        while (found) {
            found = false;
            for (RoutingNode routingNode : allocation.routingNodes()) {
                if (index >= routingNode.shards().size()) continue;
                found = true;
                shards.add(routingNode.shards().get(index));
            }
            ++index;
        }
        for (int i = 0; i < shards.size(); ++i) {
            MutableShardRouting shardRouting = (MutableShardRouting)shards.get(i);
            if (!shardRouting.started()) continue;
            RoutingNode routingNode = allocation.routingNodes().node(shardRouting.currentNodeId());
            Decision decision = allocation.deciders().canRemain(shardRouting, routingNode, allocation);
            if (decision.type() != Decision.Type.NO) continue;
            this.logger.debug("[{}][{}] allocated on [{}], but can no longer be allocated on it, moving...", shardRouting.index(), shardRouting.id(), routingNode.node());
            boolean moved = this.shardsAllocators.move(shardRouting, routingNode, allocation);
            if (!moved) {
                this.logger.debug("[{}][{}] can't move", shardRouting.index(), shardRouting.id());
                continue;
            }
            changed = true;
        }
        return changed;
    }

    private boolean electPrimariesAndUnassignDanglingReplicas(RoutingAllocation allocation) {
        boolean changed = false;
        RoutingNodes routingNodes = allocation.routingNodes();
        block0: for (MutableShardRouting shardEntry : routingNodes.unassigned()) {
            if (!shardEntry.primary() || shardEntry.assignedToNode()) continue;
            boolean bl = false;
            for (RoutingNode routingNode : routingNodes.nodesToShards().values()) {
                for (MutableShardRouting shardEntry2 : routingNode.shards()) {
                    RoutingNode node;
                    if (!shardEntry.shardId().equals(shardEntry2.shardId()) || !shardEntry2.active()) continue;
                    assert (shardEntry2.assignedToNode());
                    assert (!shardEntry2.primary());
                    changed = true;
                    shardEntry.moveFromPrimary();
                    shardEntry2.moveToPrimary();
                    if (shardEntry2.relocatingNodeId() != null && (node = routingNodes.node(shardEntry2.relocatingNodeId())) != null) {
                        for (MutableShardRouting shardRouting : node) {
                            if (!shardRouting.shardId().equals(shardEntry2.shardId()) || shardRouting.primary()) continue;
                            shardRouting.moveToPrimary();
                            break;
                        }
                    }
                    bl = true;
                    break;
                }
                if (!bl) continue;
                continue block0;
            }
        }
        ArrayList<MutableShardRouting> shardsToFail = null;
        for (MutableShardRouting mutableShardRouting : routingNodes.unassigned()) {
            if (!mutableShardRouting.primary() || mutableShardRouting.assignedToNode()) continue;
            for (RoutingNode routingNode : routingNodes.nodesToShards().values()) {
                for (MutableShardRouting shardEntry2 : routingNode.shards()) {
                    if (!mutableShardRouting.shardId().equals(shardEntry2.shardId()) || shardEntry2.active()) continue;
                    changed = true;
                    if (shardsToFail == null) {
                        shardsToFail = new ArrayList<MutableShardRouting>();
                    }
                    shardsToFail.add(shardEntry2);
                }
            }
        }
        if (shardsToFail != null) {
            for (ShardRouting shardRouting : shardsToFail) {
                this.applyFailedShard(allocation, shardRouting, false);
            }
        }
        return changed;
    }

    private void applyNewNodes(RoutingAllocation allocation) {
        for (DiscoveryNode node : allocation.nodes().dataNodes().values()) {
            if (allocation.routingNodes().nodesToShards().containsKey(node.id())) continue;
            RoutingNode routingNode = new RoutingNode(node.id(), node);
            allocation.routingNodes().nodesToShards().put(node.id(), routingNode);
        }
    }

    private boolean deassociateDeadNodes(RoutingAllocation allocation) {
        boolean changed = false;
        Iterator<RoutingNode> it = allocation.routingNodes().nodesToShards().values().iterator();
        while (it.hasNext()) {
            RoutingNode node = it.next();
            if (allocation.nodes().dataNodes().containsKey(node.nodeId())) continue;
            changed = true;
            for (MutableShardRouting shardRouting : new ArrayList<MutableShardRouting>(node.shards())) {
                this.applyFailedShard(allocation, shardRouting, false);
            }
            it.remove();
        }
        return changed;
    }

    private boolean applyStartedShards(RoutingNodes routingNodes, Iterable<? extends ShardRouting> startedShardEntries) {
        boolean dirty = false;
        block0: for (ShardRouting shardRouting : startedShardEntries) {
            RoutingNode sourceRoutingNode;
            assert (shardRouting.state() == ShardRoutingState.INITIALIZING);
            String relocatingNodeId = null;
            RoutingNode currentRoutingNode = routingNodes.nodesToShards().get(shardRouting.currentNodeId());
            if (currentRoutingNode != null) {
                for (MutableShardRouting shard : currentRoutingNode) {
                    if (!shard.shardId().equals(shardRouting.shardId())) continue;
                    relocatingNodeId = shard.relocatingNodeId();
                    if (shard.started()) break;
                    dirty = true;
                    shard.moveToStarted();
                    break;
                }
            }
            if (relocatingNodeId == null || (sourceRoutingNode = routingNodes.nodesToShards().get(relocatingNodeId)) == null) continue;
            Iterator<MutableShardRouting> shardsIter = sourceRoutingNode.iterator();
            while (shardsIter.hasNext()) {
                MutableShardRouting shard = shardsIter.next();
                if (!shard.shardId().equals(shardRouting.shardId()) || !shard.relocating()) continue;
                dirty = true;
                shardsIter.remove();
                continue block0;
            }
        }
        return dirty;
    }

    private boolean applyFailedShard(RoutingAllocation allocation, ShardRouting failedShard, boolean addToIgnoreList) {
        failedShard = new ImmutableShardRouting(failedShard);
        IndexRoutingTable indexRoutingTable = allocation.routingTable().index(failedShard.index());
        if (indexRoutingTable == null) {
            return false;
        }
        if (failedShard.relocatingNodeId() != null) {
            if (failedShard.state() == ShardRoutingState.INITIALIZING) {
                RoutingNode relocatingFromNode;
                boolean dirty = false;
                RoutingNode initializingNode = allocation.routingNodes().node(failedShard.currentNodeId());
                if (initializingNode != null) {
                    Iterator<MutableShardRouting> it = initializingNode.iterator();
                    while (it.hasNext()) {
                        MutableShardRouting shardRouting = it.next();
                        if (!shardRouting.equals(failedShard)) continue;
                        dirty = true;
                        it.remove();
                        shardRouting.deassignNode();
                        if (!addToIgnoreList) break;
                        allocation.addIgnoreShardForNode(failedShard.shardId(), failedShard.currentNodeId());
                        break;
                    }
                }
                if (dirty && (relocatingFromNode = allocation.routingNodes().node(failedShard.relocatingNodeId())) != null) {
                    for (MutableShardRouting shardRouting : relocatingFromNode) {
                        if (!shardRouting.shardId().equals(failedShard.shardId()) || shardRouting.state() != ShardRoutingState.RELOCATING) continue;
                        dirty = true;
                        shardRouting.cancelRelocation();
                        break;
                    }
                }
                return dirty;
            }
            if (failedShard.state() == ShardRoutingState.RELOCATING) {
                RoutingNode initializingNode;
                boolean dirty = false;
                RoutingNode relocatingFromNode = allocation.routingNodes().node(failedShard.currentNodeId());
                if (relocatingFromNode != null) {
                    Iterator<MutableShardRouting> it = relocatingFromNode.iterator();
                    while (it.hasNext()) {
                        MutableShardRouting shardRouting = it.next();
                        if (!shardRouting.equals(failedShard)) continue;
                        dirty = true;
                        shardRouting.cancelRelocation();
                        it.remove();
                        if (addToIgnoreList) {
                            allocation.addIgnoreShardForNode(failedShard.shardId(), failedShard.currentNodeId());
                        }
                        allocation.routingNodes().unassigned().add(new MutableShardRouting(failedShard.index(), failedShard.id(), null, failedShard.primary(), ShardRoutingState.UNASSIGNED, failedShard.version() + 1L));
                        break;
                    }
                }
                if (dirty && (initializingNode = allocation.routingNodes().node(failedShard.relocatingNodeId())) != null) {
                    Iterator<MutableShardRouting> it = initializingNode.iterator();
                    while (it.hasNext()) {
                        MutableShardRouting shardRouting = it.next();
                        if (!shardRouting.shardId().equals(failedShard.shardId()) || shardRouting.state() != ShardRoutingState.INITIALIZING) continue;
                        dirty = true;
                        shardRouting.deassignNode();
                        it.remove();
                    }
                }
                return dirty;
            }
            throw new ElasticSearchIllegalStateException("illegal state for a failed shard, relocating node id is set, but state does not match: " + failedShard);
        }
        boolean dirty = false;
        RoutingNode node = allocation.routingNodes().node(failedShard.currentNodeId());
        if (node != null) {
            Iterator<MutableShardRouting> it = node.iterator();
            while (it.hasNext()) {
                MutableShardRouting shardRouting = it.next();
                if (!shardRouting.equals(failedShard)) continue;
                dirty = true;
                if (addToIgnoreList) {
                    allocation.addIgnoreShardForNode(failedShard.shardId(), failedShard.currentNodeId());
                }
                it.remove();
                ArrayList<MutableShardRouting> shardsToMove = Lists.newArrayList();
                Iterator<MutableShardRouting> unassignedIt = allocation.routingNodes().unassigned().iterator();
                while (unassignedIt.hasNext()) {
                    MutableShardRouting unassignedShardRouting = unassignedIt.next();
                    if (!unassignedShardRouting.shardId().equals(failedShard.shardId())) continue;
                    unassignedIt.remove();
                    shardsToMove.add(unassignedShardRouting);
                }
                if (!shardsToMove.isEmpty()) {
                    allocation.routingNodes().unassigned().addAll(shardsToMove);
                }
                allocation.routingNodes().unassigned().add(new MutableShardRouting(failedShard.index(), failedShard.id(), null, failedShard.primary(), ShardRoutingState.UNASSIGNED, failedShard.version() + 1L));
                break;
            }
        }
        return dirty;
    }
}

