/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.action.index;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class NodeIndexDeletedAction
extends AbstractComponent {
    private final ThreadPool threadPool;
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();

    @Inject
    public NodeIndexDeletedAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService) {
        super(settings);
        this.threadPool = threadPool;
        this.transportService = transportService;
        this.clusterService = clusterService;
        transportService.registerHandler("cluster/nodeIndexDeleted", new NodeIndexDeletedTransportHandler());
    }

    public void add(Listener listener) {
        this.listeners.add(listener);
    }

    public void remove(Listener listener) {
        this.listeners.remove(listener);
    }

    public void nodeIndexDeleted(final String index, final String nodeId) throws ElasticSearchException {
        DiscoveryNodes nodes = this.clusterService.state().nodes();
        if (nodes.localNodeMaster()) {
            this.threadPool.generic().execute(new Runnable(){

                @Override
                public void run() {
                    NodeIndexDeletedAction.this.innerNodeIndexDeleted(index, nodeId);
                }
            });
        } else {
            this.transportService.sendRequest(this.clusterService.state().nodes().masterNode(), "cluster/nodeIndexDeleted", new NodeIndexDeletedMessage(index, nodeId), EmptyTransportResponseHandler.INSTANCE_SAME);
        }
    }

    private void innerNodeIndexDeleted(String index, String nodeId) {
        for (Listener listener : this.listeners) {
            listener.onNodeIndexDeleted(index, nodeId);
        }
    }

    static class NodeIndexDeletedMessage
    extends TransportRequest {
        String index;
        String nodeId;

        NodeIndexDeletedMessage() {
        }

        NodeIndexDeletedMessage(String index, String nodeId) {
            this.index = index;
            this.nodeId = nodeId;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.index);
            out.writeString(this.nodeId);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.index = in.readString();
            this.nodeId = in.readString();
        }
    }

    private class NodeIndexDeletedTransportHandler
    extends BaseTransportRequestHandler<NodeIndexDeletedMessage> {
        static final String ACTION = "cluster/nodeIndexDeleted";

        private NodeIndexDeletedTransportHandler() {
        }

        @Override
        public NodeIndexDeletedMessage newInstance() {
            return new NodeIndexDeletedMessage();
        }

        @Override
        public void messageReceived(NodeIndexDeletedMessage message, TransportChannel channel) throws Exception {
            NodeIndexDeletedAction.this.innerNodeIndexDeleted(message.index, message.nodeId);
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }

        @Override
        public String executor() {
            return "same";
        }
    }

    public static interface Listener {
        public void onNodeIndexDeleted(String var1, String var2);
    }
}

