/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.single.instance;

import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.UnavailableShardsException;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.single.instance.InstanceShardOperationRequest;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.TimeoutClusterStateListener;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public abstract class TransportInstanceSingleOperationAction<Request extends InstanceShardOperationRequest, Response extends ActionResponse>
extends TransportAction<Request, Response> {
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    final String transportAction;
    final String executor;

    protected TransportInstanceSingleOperationAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService) {
        super(settings, threadPool);
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.transportAction = this.transportAction();
        this.executor = this.executor();
        transportService.registerHandler(this.transportAction, new TransportHandler());
    }

    @Override
    protected void doExecute(Request request, ActionListener<Response> listener) {
        new AsyncSingleAction(this, (InstanceShardOperationRequest)request, listener).start();
    }

    protected abstract String executor();

    protected abstract String transportAction();

    protected abstract void shardOperation(Request var1, ActionListener<Response> var2) throws ElasticSearchException;

    protected abstract Request newRequest();

    protected abstract Response newResponse();

    protected abstract ClusterBlockException checkGlobalBlock(ClusterState var1, Request var2);

    protected abstract ClusterBlockException checkRequestBlock(ClusterState var1, Request var2);

    protected boolean resolveRequest(ClusterState state, Request request, ActionListener<Response> listener) {
        ((InstanceShardOperationRequest)request).index(state.metaData().concreteIndex(((InstanceShardOperationRequest)request).index()));
        return true;
    }

    protected boolean retryOnFailure(Throwable e) {
        return false;
    }

    protected TransportRequestOptions transportOptions() {
        return TransportRequestOptions.EMPTY;
    }

    protected abstract ShardIterator shards(ClusterState var1, Request var2) throws ElasticSearchException;

    class TransportHandler
    extends BaseTransportRequestHandler<Request> {
        TransportHandler() {
        }

        @Override
        public Request newInstance() {
            return TransportInstanceSingleOperationAction.this.newRequest();
        }

        @Override
        public String executor() {
            return "same";
        }

        @Override
        public void messageReceived(Request request, final TransportChannel channel) throws Exception {
            ((ActionRequest)request).listenerThreaded(false);
            TransportInstanceSingleOperationAction.this.execute(request, new ActionListener<Response>(){

                @Override
                public void onResponse(Response result) {
                    try {
                        channel.sendResponse((TransportResponse)result);
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        TransportInstanceSingleOperationAction.this.logger.warn("Failed to send response for get", e1, new Object[0]);
                    }
                }
            });
        }
    }

    static class AsyncSingleAction {
        private final ActionListener<Response> listener;
        private final Request request;
        private ShardIterator shardIt;
        private DiscoveryNodes nodes;
        private final AtomicBoolean operationStarted = new AtomicBoolean();
        final /* synthetic */ TransportInstanceSingleOperationAction this$0;

        private AsyncSingleAction(Request request, ActionListener<Response> listener) {
            this.this$0 = var1_1;
            this.request = request;
            this.listener = listener;
        }

        public void start() {
            this.start(false);
        }

        public boolean start(final boolean fromClusterEvent) throws ElasticSearchException {
            ClusterState clusterState = this.this$0.clusterService.state();
            this.nodes = clusterState.nodes();
            try {
                ClusterBlockException blockException = this.this$0.checkGlobalBlock(clusterState, this.request);
                if (blockException != null) {
                    if (blockException.retryable()) {
                        this.retry(fromClusterEvent, blockException);
                        return false;
                    }
                    throw blockException;
                }
                if (!this.this$0.resolveRequest(clusterState, this.request, this.listener)) {
                    return true;
                }
                blockException = this.this$0.checkRequestBlock(clusterState, this.request);
                if (blockException != null) {
                    if (blockException.retryable()) {
                        this.retry(fromClusterEvent, blockException);
                        return false;
                    }
                    throw blockException;
                }
                this.shardIt = this.this$0.shards(clusterState, this.request);
            }
            catch (Exception e) {
                this.listener.onFailure(e);
                return true;
            }
            if (this.shardIt.size() == 0) {
                this.retry(fromClusterEvent, null);
                return false;
            }
            assert (this.shardIt.size() == 1);
            ShardRouting shard = this.shardIt.nextOrNull();
            assert (shard != null);
            if (!shard.active()) {
                this.retry(fromClusterEvent, null);
                return false;
            }
            if (!this.operationStarted.compareAndSet(false, true)) {
                return true;
            }
            ((InstanceShardOperationRequest)this.request).shardId = this.shardIt.shardId().id();
            if (shard.currentNodeId().equals(this.nodes.localNodeId())) {
                ((InstanceShardOperationRequest)this.request).beforeLocalFork();
                this.this$0.threadPool.executor(this.this$0.executor).execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AsyncSingleAction.this.this$0.shardOperation(AsyncSingleAction.this.request, AsyncSingleAction.this.listener);
                        }
                        catch (Exception e) {
                            if (AsyncSingleAction.this.this$0.retryOnFailure(e)) {
                                AsyncSingleAction.this.retry(fromClusterEvent, null);
                            }
                            AsyncSingleAction.this.listener.onFailure(e);
                        }
                    }
                });
            } else {
                DiscoveryNode node = this.nodes.get(shard.currentNodeId());
                this.this$0.transportService.sendRequest(node, this.this$0.transportAction, (TransportRequest)this.request, this.this$0.transportOptions(), new BaseTransportResponseHandler<Response>(){

                    @Override
                    public Response newInstance() {
                        return AsyncSingleAction.this.this$0.newResponse();
                    }

                    @Override
                    public String executor() {
                        return "same";
                    }

                    @Override
                    public void handleResponse(Response response) {
                        AsyncSingleAction.this.listener.onResponse(response);
                    }

                    @Override
                    public void handleException(TransportException exp) {
                        if (exp.unwrapCause() instanceof ConnectTransportException || exp.unwrapCause() instanceof NodeClosedException || AsyncSingleAction.this.this$0.retryOnFailure(exp)) {
                            AsyncSingleAction.this.operationStarted.set(false);
                            AsyncSingleAction.this.retry(false, null);
                        } else {
                            AsyncSingleAction.this.listener.onFailure(exp);
                        }
                    }
                });
            }
            return true;
        }

        void retry(boolean fromClusterEvent, final @Nullable Throwable failure) {
            if (!fromClusterEvent) {
                ((InstanceShardOperationRequest)this.request).beforeLocalFork();
                this.this$0.clusterService.add(((InstanceShardOperationRequest)this.request).timeout(), new TimeoutClusterStateListener(){

                    @Override
                    public void postAdded() {
                        if (AsyncSingleAction.this.start(true)) {
                            AsyncSingleAction.this.this$0.clusterService.remove(this);
                        }
                    }

                    @Override
                    public void onClose() {
                        AsyncSingleAction.this.this$0.clusterService.remove(this);
                        AsyncSingleAction.this.listener.onFailure(new NodeClosedException(AsyncSingleAction.this.nodes.localNode()));
                    }

                    @Override
                    public void clusterChanged(ClusterChangedEvent event) {
                        if (AsyncSingleAction.this.start(true)) {
                            AsyncSingleAction.this.this$0.clusterService.remove(this);
                        }
                    }

                    @Override
                    public void onTimeout(TimeValue timeValue) {
                        if (AsyncSingleAction.this.start(true)) {
                            AsyncSingleAction.this.this$0.clusterService.remove(this);
                            return;
                        }
                        AsyncSingleAction.this.this$0.clusterService.remove(this);
                        Throwable listenFailure = failure;
                        if (listenFailure == null) {
                            listenFailure = AsyncSingleAction.this.shardIt == null ? new UnavailableShardsException(new ShardId(AsyncSingleAction.this.request.index(), -1), "Timeout waiting for [" + timeValue + "], request: " + AsyncSingleAction.this.request.toString()) : new UnavailableShardsException(AsyncSingleAction.this.shardIt.shardId(), "[" + AsyncSingleAction.this.shardIt.size() + "] shardIt, [" + AsyncSingleAction.this.shardIt.sizeActive() + "] active : Timeout waiting for [" + timeValue + "], request: " + AsyncSingleAction.this.request.toString());
                        }
                        AsyncSingleAction.this.listener.onFailure(listenFailure);
                    }
                });
            }
        }
    }
}

