/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class TransportAction<Request extends ActionRequest, Response extends ActionResponse>
extends AbstractComponent {
    protected final ThreadPool threadPool;

    protected TransportAction(Settings settings, ThreadPool threadPool) {
        super(settings);
        this.threadPool = threadPool;
    }

    public ActionFuture<Response> execute(Request request) throws ElasticSearchException {
        PlainActionFuture future = PlainActionFuture.newFuture();
        ((ActionRequest)request).listenerThreaded(false);
        this.execute(request, future);
        return future;
    }

    public void execute(Request request, ActionListener<Response> listener) {
        ActionRequestValidationException validationException;
        if (((ActionRequest)request).listenerThreaded()) {
            listener = new ThreadedActionListener<Response>(this.threadPool, listener);
        }
        if ((validationException = ((ActionRequest)request).validate()) != null) {
            listener.onFailure(validationException);
            return;
        }
        try {
            this.doExecute(request, listener);
        }
        catch (Exception e) {
            this.logger.trace("Error during transport action execution.", e, new Object[0]);
            listener.onFailure(e);
        }
    }

    protected abstract void doExecute(Request var1, ActionListener<Response> var2);

    static class ThreadedActionListener<Response>
    implements ActionListener<Response> {
        private final ThreadPool threadPool;
        private final ActionListener<Response> listener;

        ThreadedActionListener(ThreadPool threadPool, ActionListener<Response> listener) {
            this.threadPool = threadPool;
            this.listener = listener;
        }

        @Override
        public void onResponse(final Response response) {
            this.threadPool.generic().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ThreadedActionListener.this.listener.onResponse(response);
                    }
                    catch (Exception e) {
                        ThreadedActionListener.this.listener.onFailure(e);
                    }
                }
            });
        }

        @Override
        public void onFailure(final Throwable e) {
            this.threadPool.generic().execute(new Runnable(){

                @Override
                public void run() {
                    ThreadedActionListener.this.listener.onFailure(e);
                }
            });
        }
    }
}

