/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class IndexResponse
extends ActionResponse {
    private String index;
    private String id;
    private String type;
    private long version;
    private List<String> matches;

    public IndexResponse() {
    }

    public IndexResponse(String index, String type, String id, long version) {
        this.index = index;
        this.id = id;
        this.type = type;
        this.version = version;
    }

    public String index() {
        return this.index;
    }

    public String getIndex() {
        return this.index;
    }

    public String type() {
        return this.type;
    }

    public String getType() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    public String getId() {
        return this.id;
    }

    public long version() {
        return this.version;
    }

    public long getVersion() {
        return this.version();
    }

    public List<String> matches() {
        return this.matches;
    }

    public List<String> getMatches() {
        return this.matches;
    }

    public void matches(List<String> matches) {
        this.matches = matches;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.index = in.readString();
        this.id = in.readString();
        this.type = in.readString();
        this.version = in.readLong();
        if (in.readBoolean()) {
            int size = in.readVInt();
            if (size == 0) {
                this.matches = ImmutableList.of();
            } else if (size == 1) {
                this.matches = ImmutableList.of(in.readString());
            } else if (size == 2) {
                this.matches = ImmutableList.of(in.readString(), in.readString());
            } else if (size == 3) {
                this.matches = ImmutableList.of(in.readString(), in.readString(), in.readString());
            } else if (size == 4) {
                this.matches = ImmutableList.of(in.readString(), in.readString(), in.readString(), in.readString());
            } else if (size == 5) {
                this.matches = ImmutableList.of(in.readString(), in.readString(), in.readString(), in.readString(), in.readString());
            } else {
                this.matches = new ArrayList<String>();
                for (int i = 0; i < size; ++i) {
                    this.matches.add(in.readString());
                }
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.index);
        out.writeString(this.id);
        out.writeString(this.type);
        out.writeLong(this.version);
        if (this.matches == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(this.matches.size());
            for (String match : this.matches) {
                out.writeString(match);
            }
        }
    }
}

