/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.optimize;

import java.io.IOException;
import org.elasticsearch.action.support.broadcast.BroadcastOperationRequest;
import org.elasticsearch.action.support.broadcast.BroadcastOperationThreading;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class OptimizeRequest
extends BroadcastOperationRequest<OptimizeRequest> {
    private boolean waitForMerge = true;
    private int maxNumSegments = -1;
    private boolean onlyExpungeDeletes = false;
    private boolean flush = true;
    private boolean refresh = true;

    public OptimizeRequest(String ... indices) {
        super(indices);
        this.operationThreading(BroadcastOperationThreading.THREAD_PER_SHARD);
    }

    public OptimizeRequest() {
    }

    public boolean waitForMerge() {
        return this.waitForMerge;
    }

    public OptimizeRequest waitForMerge(boolean waitForMerge) {
        this.waitForMerge = waitForMerge;
        return this;
    }

    public int maxNumSegments() {
        return this.maxNumSegments;
    }

    public OptimizeRequest maxNumSegments(int maxNumSegments) {
        this.maxNumSegments = maxNumSegments;
        return this;
    }

    public boolean onlyExpungeDeletes() {
        return this.onlyExpungeDeletes;
    }

    public OptimizeRequest onlyExpungeDeletes(boolean onlyExpungeDeletes) {
        this.onlyExpungeDeletes = onlyExpungeDeletes;
        return this;
    }

    public boolean flush() {
        return this.flush;
    }

    public OptimizeRequest flush(boolean flush) {
        this.flush = flush;
        return this;
    }

    public boolean refresh() {
        return this.refresh;
    }

    public OptimizeRequest refresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.waitForMerge = in.readBoolean();
        this.maxNumSegments = in.readInt();
        this.onlyExpungeDeletes = in.readBoolean();
        this.flush = in.readBoolean();
        this.refresh = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.waitForMerge);
        out.writeInt(this.maxNumSegments);
        out.writeBoolean(this.onlyExpungeDeletes);
        out.writeBoolean(this.flush);
        out.writeBoolean(this.refresh);
    }

    public static final class Defaults {
        public static final boolean WAIT_FOR_MERGE = true;
        public static final int MAX_NUM_SEGMENTS = -1;
        public static final boolean ONLY_EXPUNGE_DELETES = false;
        public static final boolean FLUSH = true;
        public static final boolean REFRESH = true;
    }
}

