/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.cache.clear;

import java.io.IOException;
import org.elasticsearch.action.support.broadcast.BroadcastOperationRequest;
import org.elasticsearch.action.support.broadcast.BroadcastOperationThreading;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ClearIndicesCacheRequest
extends BroadcastOperationRequest<ClearIndicesCacheRequest> {
    private boolean filterCache = false;
    private boolean fieldDataCache = false;
    private boolean idCache = false;
    private boolean bloomCache = false;
    private String[] fields = null;

    ClearIndicesCacheRequest() {
    }

    public ClearIndicesCacheRequest(String ... indices) {
        super(indices);
        this.operationThreading(BroadcastOperationThreading.THREAD_PER_SHARD);
    }

    public boolean filterCache() {
        return this.filterCache;
    }

    public ClearIndicesCacheRequest filterCache(boolean filterCache) {
        this.filterCache = filterCache;
        return this;
    }

    public boolean fieldDataCache() {
        return this.fieldDataCache;
    }

    public ClearIndicesCacheRequest fieldDataCache(boolean fieldDataCache) {
        this.fieldDataCache = fieldDataCache;
        return this;
    }

    public ClearIndicesCacheRequest fields(String ... fields) {
        this.fields = fields;
        return this;
    }

    public String[] fields() {
        return this.fields;
    }

    public boolean idCache() {
        return this.idCache;
    }

    public ClearIndicesCacheRequest idCache(boolean idCache) {
        this.idCache = idCache;
        return this;
    }

    public boolean bloomCache() {
        return this.bloomCache;
    }

    public ClearIndicesCacheRequest bloomCache(boolean bloomCache) {
        this.bloomCache = bloomCache;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.filterCache = in.readBoolean();
        this.fieldDataCache = in.readBoolean();
        this.idCache = in.readBoolean();
        this.bloomCache = in.readBoolean();
        int size = in.readVInt();
        if (size > 0) {
            this.fields = new String[size];
            for (int i = 0; i < size; ++i) {
                this.fields[i] = in.readUTF();
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.filterCache);
        out.writeBoolean(this.fieldDataCache);
        out.writeBoolean(this.idCache);
        out.writeBoolean(this.bloomCache);
        if (this.fields == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.fields.length);
            for (String field : this.fields) {
                out.writeUTF(field);
            }
        }
    }
}

