/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.reroute;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.admin.cluster.reroute.ClusterRerouteRequest;
import org.elasticsearch.action.admin.cluster.reroute.ClusterRerouteResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportClusterRerouteAction
extends TransportMasterNodeOperationAction<ClusterRerouteRequest, ClusterRerouteResponse> {
    private final AllocationService allocationService;

    @Inject
    public TransportClusterRerouteAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, AllocationService allocationService) {
        super(settings, transportService, clusterService, threadPool);
        this.allocationService = allocationService;
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected String transportAction() {
        return "cluster/reroute";
    }

    @Override
    protected ClusterRerouteRequest newRequest() {
        return new ClusterRerouteRequest();
    }

    @Override
    protected ClusterRerouteResponse newResponse() {
        return new ClusterRerouteResponse();
    }

    @Override
    protected ClusterRerouteResponse masterOperation(final ClusterRerouteRequest request, ClusterState state) throws ElasticSearchException {
        final AtomicReference<InterruptedException> failureRef = new AtomicReference<InterruptedException>();
        final AtomicReference clusterStateResponse = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        this.clusterService.submitStateUpdateTask("cluster_reroute (api)", new ProcessedClusterStateUpdateTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ClusterState execute(ClusterState currentState) {
                ClusterState newState;
                block5: {
                    RoutingAllocation.Result routingResult = TransportClusterRerouteAction.this.allocationService.reroute(currentState, request.commands);
                    newState = ClusterState.newClusterStateBuilder().state(currentState).routingResult(routingResult).build();
                    clusterStateResponse.set(newState);
                    if (!request.dryRun) break block5;
                    ClusterState clusterState = currentState;
                    return clusterState;
                }
                try {
                    ClusterState clusterState = newState;
                    return clusterState;
                }
                catch (Exception e) {
                    TransportClusterRerouteAction.this.logger.debug("failed to reroute", e, new Object[0]);
                    failureRef.set(e);
                    latch.countDown();
                    ClusterState clusterState = currentState;
                    return clusterState;
                }
            }

            @Override
            public void clusterStateProcessed(ClusterState clusterState) {
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            failureRef.set(e);
        }
        if (failureRef.get() != null) {
            if (failureRef.get() instanceof ElasticSearchException) {
                throw (ElasticSearchException)failureRef.get();
            }
            throw new ElasticSearchException(((Throwable)failureRef.get()).getMessage(), (Throwable)failureRef.get());
        }
        return new ClusterRerouteResponse((ClusterState)clusterStateResponse.get());
    }
}

