/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;

public final class TrimFilter
extends TokenFilter {
    final boolean updateOffsets;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);

    public TrimFilter(TokenStream in, boolean updateOffsets) {
        super(in);
        this.updateOffsets = updateOffsets;
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        char[] termBuffer = this.termAtt.buffer();
        int len = this.termAtt.length();
        if (len == 0) {
            return true;
        }
        int start = 0;
        int end = 0;
        int endOff = 0;
        for (start = 0; start < len && termBuffer[start] <= ' '; ++start) {
        }
        for (end = len; end >= start && termBuffer[end - 1] <= ' '; --end) {
            ++endOff;
        }
        if (start > 0 || end < len) {
            if (start < end) {
                this.termAtt.copyBuffer(termBuffer, start, end - start);
            } else {
                this.termAtt.setEmpty();
            }
            if (this.updateOffsets) {
                int newStart = this.offsetAtt.startOffset() + start;
                int newEnd = this.offsetAtt.endOffset() - (start < end ? endOff : 0);
                this.offsetAtt.setOffset(newStart, newEnd);
            }
        }
        return true;
    }
}

