/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.insight.elasticsearch.plugin;

import java.util.HashSet;
import java.util.concurrent.ScheduledFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.ClusterAdminClient;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.hppc.cursors.ObjectObjectCursor;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.joda.time.Days;
import org.elasticsearch.common.joda.time.LocalDate;
import org.elasticsearch.common.joda.time.ReadablePartial;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;

public class InsightIndicesHousekeeperService
extends AbstractLifecycleComponent<InsightIndicesHousekeeperService> {
    private final Settings settings;
    private final ThreadPool threadPool;
    private AdminClient adminClient;
    private final String indicesPrefix;
    private final int daysOpened;
    private final int daysClosed;
    private final int daysStored;
    private final TimeValue interval;
    private ScheduledFuture<?> future;

    @Inject
    protected InsightIndicesHousekeeperService(Settings settings, ThreadPool threadPool, AdminClient adminClient) {
        super(settings);
        this.threadPool = threadPool;
        this.adminClient = adminClient;
        this.settings = settings.getByPrefix("insight.indices.management.");
        this.indicesPrefix = this.settings.get("prefix", "insight");
        this.daysOpened = this.settings.getAsInt("opened", Integer.valueOf(7));
        this.daysClosed = this.settings.getAsInt("closed", Integer.valueOf(14));
        this.daysStored = this.settings.getAsInt("stored", Integer.valueOf(0));
        this.interval = TimeValue.parseTimeValue((String)settings.get("interval"), (TimeValue)TimeValue.timeValueHours((long)1L));
        this.logger.info("Initialized {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
    }

    protected void doStart() throws ElasticsearchException {
        this.logger.info("Starting {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
        TimeValue interval = TimeValue.parseTimeValue((String)this.settings.get("initial"), (TimeValue)TimeValue.timeValueHours((long)1L));
        this.future = this.threadPool.schedule(interval, "generic", (Runnable)new Task());
    }

    protected void doStop() throws ElasticsearchException {
        this.logger.info("Stopping {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
        if (this.future != null && !this.future.isCancelled()) {
            this.future.cancel(false);
        }
    }

    protected void doClose() throws ElasticsearchException {
        if (this.future != null && !this.future.isCancelled()) {
            this.future.cancel(true);
        }
    }

    class Task
    implements Runnable {
        private final Pattern pattern;

        Task() {
            this.pattern = Pattern.compile(InsightIndicesHousekeeperService.this.indicesPrefix + "-([0-9]{4})\\.([0-9]{2})\\.([0-9]{2})");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean reschedule = true;
            try {
                ClusterAdminClient clusterAdminClient = InsightIndicesHousekeeperService.this.adminClient.cluster();
                ClusterStateResponse state = (ClusterStateResponse)clusterAdminClient.state((ClusterStateRequest)clusterAdminClient.prepareState().request()).actionGet();
                if (!state.getState().nodes().getLocalNode().isMasterNode()) {
                    return;
                }
                HashSet<String> toClose = new HashSet<String>();
                HashSet<String> toDelete = new HashSet<String>();
                LocalDate now = new LocalDate();
                for (ObjectObjectCursor it : state.getState().metaData().indices()) {
                    CloseIndexRequest req;
                    String index = ((IndexMetaData)it.value).getIndex();
                    Matcher matcher = this.pattern.matcher(index);
                    if (matcher.find()) {
                        LocalDate date = new LocalDate(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
                        int daysOld = Days.daysBetween((ReadablePartial)date, (ReadablePartial)now).getDays();
                        if (daysOld > 0 && InsightIndicesHousekeeperService.this.daysOpened > 0 && daysOld > InsightIndicesHousekeeperService.this.daysOpened) {
                            if (daysOld > InsightIndicesHousekeeperService.this.daysOpened && daysOld <= InsightIndicesHousekeeperService.this.daysClosed) {
                                InsightIndicesHousekeeperService.this.logger.debug("Adding index to close: Index {} is {} day(s) old", new Object[]{index, daysOld});
                                toClose.add(index);
                            } else if (InsightIndicesHousekeeperService.this.daysClosed >= 0 && daysOld > InsightIndicesHousekeeperService.this.daysClosed && daysOld > InsightIndicesHousekeeperService.this.daysStored) {
                                InsightIndicesHousekeeperService.this.logger.debug("Adding index to delete: Index {} is {} day(s) old", new Object[]{index, daysOld});
                                toDelete.add(index);
                            }
                        } else {
                            InsightIndicesHousekeeperService.this.logger.debug("Ignoring index: Index {} is only {} day(s) old", new Object[]{index, daysOld});
                        }
                    } else {
                        InsightIndicesHousekeeperService.this.logger.debug("Ignoring index: Name {} does not match the supported pattern ({})", new Object[]{index, this.pattern.pattern()});
                    }
                    IndicesAdminClient indicesAdminClient = InsightIndicesHousekeeperService.this.adminClient.indices();
                    if (!toClose.isEmpty()) {
                        InsightIndicesHousekeeperService.this.logger.info("Closing indices: {}", new Object[]{toClose});
                        String[] indices = toClose.toArray(new String[toClose.size()]);
                        req = (CloseIndexRequest)indicesAdminClient.prepareClose(indices).request();
                        indicesAdminClient.close(req).actionGet();
                    }
                    if (toDelete.isEmpty()) continue;
                    InsightIndicesHousekeeperService.this.logger.info("Deleting indices: {}", new Object[]{toDelete});
                    String[] indices = toDelete.toArray(new String[toDelete.size()]);
                    req = (DeleteIndexRequest)indicesAdminClient.prepareDelete(indices).request();
                    indicesAdminClient.delete((DeleteIndexRequest)req).actionGet();
                }
            }
            catch (ElasticsearchException e) {
                if (e.getCause() instanceof InterruptedException) {
                    reschedule = true;
                } else {
                    InsightIndicesHousekeeperService.this.logger.error("Error performing indices management", (Throwable)e, new Object[0]);
                }
            }
            finally {
                if (reschedule) {
                    InsightIndicesHousekeeperService.this.future = InsightIndicesHousekeeperService.this.threadPool.schedule(InsightIndicesHousekeeperService.this.interval, "generic", (Runnable)this);
                }
            }
        }
    }
}

