/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.insight.elasticsearch.storage.log.impl;

import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.insight.elasticsearch.AbstractElasticsearchStorage;
import io.fabric8.insight.storage.StorageService;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.elasticsearch.node.Node;

@Component(immediate=true, name="io.fabric8.insight.log.elasticsearch")
@Service(value={StorageService.class})
public class ElasticsearchLogStorage
extends AbstractElasticsearchStorage {
    @Reference(name="node", referenceInterface=Node.class, target="(cluster.name=insight)")
    private final ValidatingReference<Node> node = new ValidatingReference();

    @Activate
    public void activate() {
        this.running = true;
        this.putInsightTemplate();
        this.thread = new Thread((Runnable)((Object)this), "ElasticStorage");
        this.thread.start();
    }

    @Deactivate
    public void deactivate() {
        this.running = false;
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    private void bindNode(Node node) {
        this.node.bind((Object)node);
    }

    private void unbindNode(Node node) {
        this.node.unbind((Object)node);
    }

    public Node getNode() {
        return (Node)this.node.get();
    }
}

