/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.insight.activemq.audit;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public final class ScriptUtils {
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
    private static final ObjectMapper mapper = new ObjectMapper();

    public static String toIso(Date d) {
        return format.format(d);
    }

    public static String toJson(Object o) {
        try {
            if (o instanceof Collection) {
                StringBuilder sb = new StringBuilder();
                sb.append("[");
                for (Object c : (Collection)o) {
                    if (sb.length() > 1) {
                        sb.append(",");
                    }
                    sb.append(ScriptUtils.toJson(c));
                }
                sb.append("]");
                return sb.toString();
            }
            if (o instanceof Map) {
                StringBuilder sb = new StringBuilder();
                sb.append("{");
                for (Map.Entry e : ((Map)o).entrySet()) {
                    if (sb.length() > 1) {
                        sb.append(",");
                    }
                    sb.append(ScriptUtils.toJson(e.getKey().toString()));
                    sb.append(":");
                    sb.append(ScriptUtils.toJson(e.getValue()));
                }
                sb.append("}");
                return sb.toString();
            }
            if (o == null) {
                return "null";
            }
            if (o instanceof Date) {
                return "\"" + ScriptUtils.toIso((Date)o) + "\"";
            }
            return mapper.writeValueAsString((Object)o.toString());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not serialize " + o, e);
        }
    }

    public static Map parseJson(String str) {
        try {
            return (Map)mapper.readValue(str, Map.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not deserialize " + str, e);
        }
    }

    static {
        mapper.getSerializationConfig().with((DateFormat)format);
    }
}

