/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.insight.activemq.base;

import io.fabric8.insight.activemq.audit.Auditor;
import io.fabric8.insight.activemq.base.InsightBrokerPlugin;
import io.fabric8.insight.activemq.base.StorageProxy;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerPlugin;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator,
ManagedService {
    public static final String INSIGHT_ACTIVEMQ_PID = "io.fabric8.insight.activemq";
    private static final transient Logger LOG = LoggerFactory.getLogger(Activator.class);
    private static Activator INSTANCE;
    private final Map<String, InsightBrokerPlugin> plugins = new HashMap<String, InsightBrokerPlugin>();
    private StorageProxy storageProxy = new StorageProxy();
    private BundleContext bundleContext;
    private MBeanServer mbeanServer;
    private ServiceRegistration<ManagedService> registration;
    private List<ServiceRegistration> commandRegistrations;

    public Activator() {
        this.plugins.put("auditor", new Auditor(this.storageProxy));
    }

    public static Broker installPlugins(Broker broker) throws Exception {
        Activator activator = INSTANCE;
        if (activator != null) {
            return activator.doInstallPlugins(broker);
        }
        return broker;
    }

    protected Broker doInstallPlugins(Broker broker) throws Exception {
        for (BrokerPlugin brokerPlugin : this.plugins.values()) {
            broker = brokerPlugin.installPlugin(broker);
        }
        return broker;
    }

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.storageProxy.setContext(context);
        this.storageProxy.init();
        this.mbeanServer = this.lookupMBeanServer();
        if (this.mbeanServer != null) {
            for (BrokerPlugin brokerPlugin : this.plugins.values()) {
                try {
                    this.mbeanServer.registerMBean(brokerPlugin, this.getObjectName(brokerPlugin));
                }
                catch (Exception e) {
                    LOG.warn("An error occured during mbean server unregistration: " + e, (Throwable)e);
                }
            }
        }
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("service.pid", INSIGHT_ACTIVEMQ_PID);
        this.registration = this.bundleContext.registerService(ManagedService.class, (Object)this, props);
        this.commandRegistrations = Arrays.asList(new Object[0]);
        INSTANCE = this;
    }

    public void stop(BundleContext context) throws Exception {
        INSTANCE = null;
        for (ServiceRegistration serviceRegistration : this.commandRegistrations) {
            serviceRegistration.unregister();
        }
        this.registration.unregister();
        if (this.mbeanServer != null) {
            for (BrokerPlugin brokerPlugin : this.plugins.values()) {
                try {
                    this.mbeanServer.unregisterMBean(this.getObjectName(brokerPlugin));
                }
                catch (Exception e) {
                    LOG.warn("An error occured during mbean server unregistration: " + e, (Throwable)e);
                }
            }
        }
        this.storageProxy.destroy();
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        HashMap props = new HashMap();
        for (String plugin : this.plugins.keySet()) {
            props.put(plugin, new HashMap());
        }
        if (properties != null) {
            Enumeration<String> es = properties.keys();
            while (es.hasMoreElements()) {
                String key = es.nextElement();
                Object val = properties.get(key);
                for (String plugin : this.plugins.keySet()) {
                    if (!key.startsWith(plugin + ".")) continue;
                    key = key.substring((plugin + ".").length());
                    ((Map)props.get(plugin)).put(key, val != null ? val.toString() : null);
                }
            }
        }
        for (String key : this.plugins.keySet()) {
            Map p = (Map)props.get(key);
            this.plugins.get(key).update(p);
        }
    }

    protected ObjectName getObjectName(BrokerPlugin plugin) throws MalformedObjectNameException {
        return new ObjectName("io.fabric8.insight:type=ActiveMQ" + plugin.getClass().getSimpleName());
    }

    protected MBeanServer lookupMBeanServer() {
        ServiceReference ref = this.bundleContext.getServiceReference(MBeanServer.class.getName());
        if (ref != null) {
            return (MBeanServer)this.bundleContext.getService(ref);
        }
        LOG.warn("Could not find MBeanServer in the OSGi registry so using the platform MBeanServer instead");
        return ManagementFactory.getPlatformMBeanServer();
    }
}

