/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.insight.activemq.audit;

import io.fabric8.insight.activemq.audit.AuditorMBean;
import io.fabric8.insight.activemq.audit.IoUtils;
import io.fabric8.insight.activemq.audit.ScriptUtils;
import io.fabric8.insight.activemq.base.SwichtableBrokerPlugin;
import io.fabric8.insight.storage.StorageService;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.command.Message;
import org.mvel2.ParserContext;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRuntime;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Auditor
extends SwichtableBrokerPlugin
implements ManagedService,
AuditorMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(Auditor.class);
    private StorageService storage;
    private String type = "activemq";
    private Dictionary<String, ?> properties;
    private ParserContext context;
    private Map<String, CompiledTemplate> templates = new ConcurrentHashMap<String, CompiledTemplate>();
    private Map<URL, String> sources = new ConcurrentHashMap<URL, String>();
    private URL defaultTemplateUrl = this.getClass().getResource("default.mvel");

    public Auditor(StorageService storage) {
        super(false);
        this.storage = storage;
        this.context = new ParserContext();
        try {
            this.context.addImport("toJson", ScriptUtils.class.getMethod("toJson", Object.class));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Unable to find method toJson", e);
        }
    }

    public void send(ProducerBrokerExchange producerExchange, Message messageSend) throws Exception {
        if (this.isEnabled((MessageReference)messageSend)) {
            String json = this.toJson("Sent", (MessageReference)messageSend);
            this.storage.store(this.type, System.currentTimeMillis(), json);
        }
        super.send(producerExchange, messageSend);
    }

    public void messageConsumed(ConnectionContext context, MessageReference messageReference) {
        if (this.isEnabled(messageReference)) {
            String json = this.toJson("Consumed", messageReference);
            this.storage.store(this.type, System.currentTimeMillis(), json);
        }
        super.messageConsumed(context, messageReference);
    }

    public void messageDelivered(ConnectionContext context, MessageReference messageReference) {
        if (this.isEnabled(messageReference)) {
            String json = this.toJson("Delivered", messageReference);
            this.storage.store(this.type, System.currentTimeMillis(), json);
        }
        super.messageDelivered(context, messageReference);
    }

    public void messageDiscarded(ConnectionContext context, Subscription sub, MessageReference messageReference) {
        if (this.isEnabled(messageReference)) {
            String json = this.toJson("Discarded", messageReference);
            this.storage.store(this.type, System.currentTimeMillis(), json);
        }
        super.messageDiscarded(context, sub, messageReference);
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        this.properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String toJson(String eventType, MessageReference messageReference) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Auditor.class.getClassLoader());
            CompiledTemplate template = this.getTemplate(eventType, messageReference);
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("event", eventType);
            vars.put("host", System.getProperty("karaf.name"));
            vars.put("timestamp", new Date());
            vars.put("message", messageReference.getMessage());
            vars.put("messageReference", messageReference);
            String string = TemplateRuntime.execute((CompiledTemplate)template, (Object)this.context, vars).toString();
            return string;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private CompiledTemplate getTemplate(String event, MessageReference message) {
        String source = this.getTemplateSource(event, message);
        CompiledTemplate template = this.templates.get(source);
        if (template == null) {
            template = TemplateCompiler.compileTemplate((String)source, (ParserContext)this.context);
            this.templates.put(source, template);
        }
        return template;
    }

    private String getTemplateSource(String event, MessageReference message) {
        String source = null;
        URL url = this.getTemplateUrl(event, message);
        if (url != null) {
            try {
                source = this.loadSource(url);
            }
            catch (IOException e) {
                LOGGER.warn("Unable to load mvel template " + url, (Throwable)e);
            }
        }
        if (source == null) {
            try {
                source = this.loadSource(this.defaultTemplateUrl);
            }
            catch (IOException e) {
                throw new IllegalStateException("Default template could not be loaded", e);
            }
        }
        return source;
    }

    private URL getTemplateUrl(String event, MessageReference message) {
        return null;
    }

    private String loadSource(URL url) throws IOException {
        String source = this.sources.get(url);
        if (source == null) {
            source = IoUtils.loadFully(url);
            this.sources.put(url, source);
        }
        return source;
    }
}

