/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.repo.git;

import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.repo.git.GitRepoClient;
import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitRepoKubernetes {
    private static final transient Logger LOG = LoggerFactory.getLogger(GitRepoKubernetes.class);
    public static final String JENKINS_GOGS_USER = "JENKINS_GOGS_USER";
    public static final String JENKINS_GOGS_PASSWORD = "JENKINS_GOGS_PASSWORD";

    public static GitRepoClient createGitRepoClient(KubernetesClient kubernetes) {
        return GitRepoKubernetes.createGitRepoClient(kubernetes, null, null);
    }

    public static GitRepoClient createGitRepoClient(KubernetesClient kubernetes, String userName, String password) {
        String address;
        if (Strings.isNullOrBlank((String)userName)) {
            userName = Systems.getEnvVarOrSystemProperty((String)JENKINS_GOGS_USER, (String)"gogsadmin");
        }
        if (Strings.isNullOrBlank((String)password)) {
            password = Systems.getEnvVarOrSystemProperty((String)JENKINS_GOGS_PASSWORD, (String)"RedHat$1");
        }
        String namespace = kubernetes.getNamespace();
        try {
            address = kubernetes.getServiceURL("gogs", namespace, "http", true);
            if (Strings.isNullOrBlank((String)address)) {
                LOG.warn("No Gogs service could be found in kubernetes " + namespace + " on address: " + kubernetes.getAddress());
                return null;
            }
        }
        catch (IllegalArgumentException e) {
            LOG.warn("No Gogs service could be found in kubernetes " + namespace + " on address: " + kubernetes.getAddress());
            return null;
        }
        LOG.info("Logging into Gogs at " + address + " as user " + userName);
        return new GitRepoClient(address, userName, password);
    }
}

