/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.repo.git;

import io.fabric8.repo.git.CreateRepositoryDTO;
import io.fabric8.repo.git.CreateWebhookDTO;
import io.fabric8.repo.git.GitApi;
import io.fabric8.repo.git.OrganisationDTO;
import io.fabric8.repo.git.RepositoryDTO;
import io.fabric8.repo.git.WebHookDTO;
import io.fabric8.utils.cxf.WebClients;
import java.util.List;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;

public class GitRepoClient {
    private final String address;
    private final String username;
    private final String password;
    private GitApi api;

    public GitRepoClient(String address, String username, String password) {
        this.address = address;
        this.username = username;
        this.password = password;
    }

    public RepositoryDTO createRepository(CreateRepositoryDTO createRepository) {
        return this.getApi().createRepository(createRepository);
    }

    public List<RepositoryDTO> listRepositories() {
        return this.getApi().listRepositories();
    }

    public List<RepositoryDTO> listOrganisationRepositories(String organisation) {
        return this.getApi().listOrganisationRepositories(organisation);
    }

    public List<OrganisationDTO> listUserOrganisations() {
        return this.getApi().listUserOrganisations();
    }

    public WebHookDTO createWebhook(String owner, String repo, CreateWebhookDTO dto) {
        return this.getApi().createWebhook(owner, repo, dto);
    }

    protected GitApi getApi() {
        if (this.api == null) {
            this.api = this.createWebClient(GitApi.class);
        }
        return this.api;
    }

    protected <T> T createWebClient(Class<T> clientType) {
        List providers = WebClients.createProviders();
        WebClient webClient = WebClient.create((String)this.address, (List)providers);
        WebClients.disableSslChecks((WebClient)webClient);
        WebClients.configureUserAndPassword((WebClient)webClient, (String)this.username, (String)this.password);
        return (T)JAXRSClientFactory.fromClient((Client)webClient, clientType);
    }
}

