/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.commit;

import java.util.Collection;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.gitective.core.filter.commit.CommitDiffEditFilter;

public class DiffCountFilter
extends CommitDiffEditFilter {
    private int count;

    public DiffCountFilter() {
    }

    public DiffCountFilter(boolean detectRenames) {
        super(detectRenames);
    }

    @Override
    protected CommitDiffEditFilter markStart(RevCommit commit) {
        this.count = 0;
        return super.markStart(commit);
    }

    @Override
    public boolean include(RevWalk walker, RevCommit commit, Collection<DiffEntry> diffs) {
        super.include(walker, commit, diffs);
        return this.include(commit, diffs, this.count) ? true : this.include(false);
    }

    @Override
    protected boolean include(RevCommit commit, DiffEntry diff, Collection<Edit> edits) {
        for (Edit edit : edits) {
            switch (edit.getType()) {
                case DELETE: {
                    this.count += edit.getLengthA();
                    break;
                }
                case INSERT: 
                case REPLACE: {
                    this.count += edit.getLengthB();
                }
            }
        }
        return true;
    }

    protected boolean include(RevCommit commit, Collection<DiffEntry> diffs, int diffCount) {
        return true;
    }

    @Override
    public RevFilter clone() {
        return new DiffCountFilter(this.detectRenames);
    }
}

