/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.stat;

import java.io.Serializable;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;

public class UserCommitActivity
implements Serializable {
    private static final long serialVersionUID = 3567351283712945310L;
    public static final int SIZE = 16;
    public static final int GROWTH = 10;
    private final String name;
    private final String email;
    private int index;
    private byte[][] commits;
    private long[] times;
    private long first = Long.MAX_VALUE;
    private long last = Long.MIN_VALUE;

    public UserCommitActivity(String name, String email) {
        this.name = name;
        this.email = email;
        this.commits = new byte[16][];
        this.times = new long[16];
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public UserCommitActivity include(RevCommit commit, PersonIdent user) {
        long when = user.getWhen().getTime();
        if (this.index == this.commits.length) {
            int newSize = this.commits.length;
            newSize += Math.max(16, newSize / 10);
            byte[][] newCommits = new byte[newSize][];
            System.arraycopy(this.commits, 0, newCommits, 0, this.commits.length);
            this.commits = newCommits;
            long[] newTimes = new long[newSize];
            System.arraycopy(this.times, 0, newTimes, 0, this.times.length);
            this.times = newTimes;
        }
        byte[] id = new byte[20];
        commit.copyRawTo(id, 0);
        this.commits[this.index] = id;
        this.times[this.index] = when;
        ++this.index;
        if (when < this.first) {
            this.first = when;
        }
        if (when > this.last) {
            this.last = when;
        }
        return this;
    }

    public long[] getTimes() {
        long[] copy = new long[this.index];
        System.arraycopy(this.times, 0, copy, 0, this.index);
        return copy;
    }

    public byte[][] getRawIds() {
        byte[][] raw = new byte[this.index][];
        System.arraycopy(this.commits, 0, raw, 0, this.index);
        return raw;
    }

    public ObjectId[] getIds() {
        ObjectId[] ids = new ObjectId[this.index];
        for (int i = 0; i < this.index; ++i) {
            ids[i] = ObjectId.fromRaw((byte[])this.commits[i]);
        }
        return ids;
    }

    public int getCount() {
        return this.index;
    }

    public ObjectId getFirst() {
        return this.index > 0 ? ObjectId.fromRaw((byte[])this.commits[this.index - 1]) : null;
    }

    public ObjectId getLast() {
        return this.index > 0 ? ObjectId.fromRaw((byte[])this.commits[0]) : null;
    }

    public long getEarliest() {
        return this.index > 0 ? this.first : 0L;
    }

    public long getLatest() {
        return this.index > 0 ? this.last : 0L;
    }
}

