/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.commit;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.gitective.core.filter.commit.CommitDiffFilter;
import org.gitective.core.filter.commit.CommitFilter;

public class LastCommitDiffFilter
extends CommitDiffFilter {
    private final Map<String, RevCommit> commits = new HashMap<String, RevCommit>();
    private int remaining;
    private RevTree tree;

    public LastCommitDiffFilter() {
    }

    public LastCommitDiffFilter(boolean detectRenames) {
        super(detectRenames);
    }

    @Override
    public boolean include(RevWalk walker, RevCommit commit, Collection<DiffEntry> diffs) throws IOException {
        if (this.tree == null) {
            this.tree = commit.getTree();
            TreeWalk treeWalk = new TreeWalk(walker.getObjectReader());
            treeWalk.setRecursive(true);
            treeWalk.addTree((AnyObjectId)this.tree);
            while (treeWalk.next()) {
                this.commits.put(treeWalk.getPathString(), null);
            }
            this.remaining = this.commits.size();
        }
        for (DiffEntry diff : diffs) {
            RevCommit blobCommit;
            String path;
            switch (diff.getChangeType()) {
                case DELETE: {
                    path = diff.getOldPath();
                    break;
                }
                default: {
                    path = diff.getNewPath();
                }
            }
            if (!this.commits.containsKey(path) || (blobCommit = this.commits.get(path)) != null) continue;
            this.commits.put(path, commit);
            --this.remaining;
            if (this.remaining != 0) continue;
            return this.include(false);
        }
        return true;
    }

    public RevTree getTree() {
        return this.tree;
    }

    public Map<String, RevCommit> getCommits() {
        return this.commits;
    }

    @Override
    public CommitFilter reset() {
        this.commits.clear();
        this.tree = null;
        this.remaining = 0;
        return super.reset();
    }

    @Override
    public RevFilter clone() {
        return new LastCommitDiffFilter(this.detectRenames);
    }
}

